<?php

/**
 * Laravel - A PHP Framework For Web Artisans
 *
 * @package  Laravel
 * @author   Taylor Otwell <taylor@laravel.com>
 */

$uri = urldecode(
    parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH)
);

// This file allows us to emulate Apache's "mod_rewrite" functionality from the
// built-in PHP web server. This provides a convenient way to test a Laravel
// application without having installed a "real" web server software here.
if ($uri !== '/' && file_exists(__DIR__.'/public'.$uri)) {
    // Add CORS headers for static files (fonts, css, js, images)
    $ext = strtolower(pathinfo($uri, PATHINFO_EXTENSION));
    $corsExtensions = ['ttf', 'ttc', 'otf', 'eot', 'woff', 'woff2', 'css', 'js', 'gif', 'png', 'jpg', 'jpeg', 'svg', 'ico', 'webp'];
    if (in_array($ext, $corsExtensions)) {
        header('Access-Control-Allow-Origin: *');
        $mimeTypes = [
            'ttf' => 'font/ttf',
            'otf' => 'font/otf',
            'woff' => 'font/woff',
            'woff2' => 'font/woff2',
            'eot' => 'application/vnd.ms-fontobject',
            'css' => 'text/css',
            'js' => 'application/javascript',
        ];
        if (isset($mimeTypes[$ext])) {
            header('Content-Type: ' . $mimeTypes[$ext]);
        }
        readfile(__DIR__.'/public'.$uri);
        return true;
    }
    return false;
}

require_once __DIR__.'/public/index.php';
