<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\PortfolioController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\ContactUsController;
use App\Http\Controllers\SitemapController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\AdminsController;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\TermsController;
use App\Http\Controllers\Admin\AboutUsController;
use App\Http\Controllers\Admin\ContactUSSettings;
use App\Http\Controllers\Admin\ContactusController as AdminContactusController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\ServicesController;
use App\Http\Controllers\Admin\HostsController;
use App\Http\Controllers\Admin\OffersController;
use App\Http\Controllers\Admin\TestMonialsController;
use App\Http\Controllers\Admin\PortfolioController as AdminPortfolioController;
use App\Http\Controllers\Admin\BlogsController;
use App\Http\Controllers\Admin\SiteMapController as AdminSiteMapController;
use App\Http\Controllers\Admin\ExportController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/try', function () {
    return "op";
});

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('portfolio', [HomeController::class, 'portfolio']);
Route::get('about_us', [HomeController::class, 'about_us']);
Route::get('blogs', [HomeController::class, 'blogs']);
Route::get('faq', [HomeController::class, 'faq']);

// Login routes
Route::get('login', fn() => redirect('admin/login'));
Route::get('admin/login', [LoginController::class, 'GetLogin'])->name('login');
Route::post('/check', [LoginController::class, 'postLogin']);
Route::get('/service/{name}', [ServiceController::class, 'show']);
Route::get('/portfolio/{name}', [PortfolioController::class, 'show']);
Route::get('/blog/{title}', [BlogController::class, 'show']);

Route::post('get/help', [ContactUsController::class, 'send']);
Route::get('/contact/us', [ContactUsController::class, 'getContact']);

// Dynamic Sitemap for SEO
Route::get('/sitemap.xml', [SitemapController::class, 'index']);

// Language Switcher
Route::get('lang/{locale}', function ($locale) {
    if (in_array($locale, ['ar', 'en'])) {
        session()->put('locale', $locale);
        app()->setLocale($locale);
    }
    return redirect()->back();
})->name('lang.switch');

Route::middleware(['auth'])->group(function () {
    
    Route::prefix('admin')->group(function () {
        Route::get('/home', function () {
            return view('admin.home');
        });

        Route::resource('admins', AdminsController::class);
        Route::get('admin/{id}/delete', [AdminsController::class, 'destroy']);
        Route::get('users', [UsersController::class, 'Users']);
        Route::resource('terms', TermsController::class);
        Route::resource('about_us', AboutUsController::class);
        Route::resource('contact_us_settings', ContactUSSettings::class);
        Route::get('contact_us_settings/map', [ContactUSSettings::class, 'show']);
        Route::get('get_contact_us', [AdminContactusController::class, 'index']);
        Route::get('contact_us/{id}/reply', [AdminContactusController::class, 'GetReply']);
        Route::post('contact_us/reply', [AdminContactusController::class, 'PostReply']);
        Route::get('contact_us/{id}/delete', [AdminContactusController::class, 'destroy']);
        
        Route::resource('slider', SliderController::class);
        Route::get('slider/{id}/delete', [SliderController::class, 'destroy']);
       
        Route::resource('services', ServicesController::class);
        Route::get('services/{id}/delete', [ServicesController::class, 'destroy']);

        Route::resource('hosts', HostsController::class);
        Route::get('hosts/{id}/delete', [HostsController::class, 'destroy']);

        Route::resource('offers', OffersController::class);
        Route::get('offers/{id}/delete', [OffersController::class, 'destroy']);

        Route::resource('testmonials', TestMonialsController::class);
        Route::get('testmonials/{id}/delete', [TestMonialsController::class, 'destroy']);
        
        Route::resource('portfolio', AdminPortfolioController::class);
        Route::get('portfolio/{id}/delete', [AdminPortfolioController::class, 'destroy']);
        Route::get('gallery_delete/{id}', [AdminPortfolioController::class, 'destroyImage']);
        Route::resource('blogs', BlogsController::class);
        Route::get('blogs/{id}/delete', [BlogsController::class, 'destroy']);

        Route::get('sitemap/generate', [AdminSiteMapController::class, 'create']);
        
        // Export routes
        Route::get('export/contacts', [ExportController::class, 'exportContacts'])->name('admin.export.contacts');
        
        Route::get('/logout', [LoginController::class, 'logout']);
    });
});
