<?php echo '<?xml version="1.0" encoding="UTF-8"?>'; ?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:xhtml="http://www.w3.org/1999/xhtml">
    <!-- Homepage -->
    <url>
        <loc>https://bedayh4it.com/</loc>
        <xhtml:link rel="alternate" hreflang="ar-sa" href="https://bedayh4it.com/"/>
        <changefreq>weekly</changefreq>
        <priority>1.0</priority>
        <lastmod>{{ now()->toW3cString() }}</lastmod>
    </url>
    
    <!-- Static Pages -->
    <url>
        <loc>https://bedayh4it.com/about_us</loc>
        <changefreq>monthly</changefreq>
        <priority>0.8</priority>
    </url>
    <url>
        <loc>https://bedayh4it.com/contact/us</loc>
        <changefreq>monthly</changefreq>
        <priority>0.8</priority>
    </url>
    <url>
        <loc>https://bedayh4it.com/portfolio</loc>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    <url>
        <loc>https://bedayh4it.com/blogs</loc>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
    </url>
    <url>
        <loc>https://bedayh4it.com/faq</loc>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
    </url>
    
    <!-- Services -->
    @foreach($services as $service)
    <url>
        <loc>https://bedayh4it.com/service/{{ str_replace(' ', '_', $service->name) }}</loc>
        <changefreq>monthly</changefreq>
        <priority>0.9</priority>
        <lastmod>{{ $service->updated_at ? $service->updated_at->toW3cString() : now()->toW3cString() }}</lastmod>
    </url>
    @endforeach
    
    <!-- Portfolio Items -->
    @foreach($portfolios as $portfolio)
    <url>
        <loc>https://bedayh4it.com/portfolio/{{ str_replace(' ', '_', $portfolio->name) }}</loc>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
        <lastmod>{{ $portfolio->updated_at ? $portfolio->updated_at->toW3cString() : now()->toW3cString() }}</lastmod>
    </url>
    @endforeach
    
    <!-- Blog Posts -->
    @foreach($blogs as $blog)
    <url>
        <loc>https://bedayh4it.com/blog/{{ str_replace(' ', '_', $blog->title) }}</loc>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
        <lastmod>{{ $blog->updated_at ? $blog->updated_at->toW3cString() : now()->toW3cString() }}</lastmod>
    </url>
    @endforeach
</urlset>
