@extends('site.layout')
   <link href="{{ URL::to('/') }}/assets/site/css/bootstrap-rtl.css" rel="stylesheet" type="text/css"/>

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="{{ URL::to('/') }}/assets/site/css/inc/plugins.css">
    <!-- CSS Global Compulsory -->
    
    <link rel="stylesheet" href="{{ URL::to('/') }}/assets/site/css/style.css">
@section('metaTags')
  <title>  {{@$portfolio->name}}  | {{@$setting->name}} </title>
  <meta name='description' itemprop='description' content='{!! @$portfolio->content !!}' />
  <meta name='keywords' content='{{@$info->keywords}},{!! @$portfolio->content !!},{{@$portfolio->name}}' />
  <meta property='article:section' content='{!!@$portfolio->content!!}' />

  <meta property="og:description"content="{{@$portfolio->content}}" />
  <meta property="og:title"content="{{@$portfolio->name}}   | {{@$setting->name}} " />
  <meta property="og:url"content="{{URL::to('/portfolio').@str_replace(' ','_',$portfolio->name)}}" />
  <meta property="og:site_name"content="{{@$setting->name}}" />
  <meta property="og:image" content="{{URL::to('/').@$portfolio->images()->first()->image}}">

  <meta name="twitter:card"content="{{@$portfolio->content}}" />
  <meta name="twitter:title"content="  {{@$portfolio->name}}   | {{@$setting->name}}" />
  <meta name="twitter:site"content="bedayh4it.com" />

  <!-- BreadcrumbList Schema -->
  <script type="application/ld+json">
  {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
          {"@type": "ListItem", "position": 1, "name": "الرئيسية", "item": "{{ URL::to('/') }}"},
          {"@type": "ListItem", "position": 2, "name": "أعمالنا", "item": "{{ URL::to('/portfolio') }}"},
          {"@type": "ListItem", "position": 3, "name": "{{ $portfolio->name }}", "item": "{{ URL::to('/portfolio/'.str_replace(' ','_',$portfolio->name)) }}"}
      ]
  }
  </script>
@stop
 @section('content')
   <main class="main_site">
     <div class="ds-hero ds-page-hero">
       <div class="container">
         <h1 class="ds-hero-title ds-text-center">{{@$portfolio->name}}</h1>
         <p class="ds-breadcrumb">الرئيسية / أعمالنا / {{@$portfolio->name}}</p>
       </div>
     </div>

     <section class="ds-section">
       <div class="container">
         <div class="ds-service-layout">
           <div class="ds-service-main">
             <div class="ds-portfolio-gallery">
               <div id="myCarousel" class="carousel slide" data-ride="carousel">
                 <ol class="carousel-indicators">
                   @foreach($portfolio->images as $key=> $image)
                   <li data-target="#myCarousel" data-slide-to="{{$key}}" class="{{ $loop->first ? 'active':''}}"></li>
                   @endforeach
                 </ol>
                 <div class="carousel-inner">
                   @foreach($portfolio->images as $key=> $image)
                   <div class="{{ $loop->first ? 'item active': 'item'}}">
                     <img src="{{URL::to('/')}}{{$image->image}}" alt="{{$portfolio->name}}" loading="lazy">
                   </div>
                   @endforeach
                 </div>
                 <a class="left carousel-control" href="#myCarousel" data-slide="prev">
                   <span class="glyphicon glyphicon-chevron-left"></span>
                 </a>
                 <a class="right carousel-control" href="#myCarousel" data-slide="next">
                   <span class="glyphicon glyphicon-chevron-right"></span>
                 </a>
               </div>
             </div>

             <div class="ds-service-content">
               {!! @$portfolio->content !!}
             </div>

             @php
               $shareUrl = urlencode(URL::to('/portfolio/'.str_replace(' ','_',$portfolio->name)));
               $shareTitle = urlencode($portfolio->name);
             @endphp
             <div class="ds-share-section">
               <h4>مشاركة عن طريق:</h4>
               <div class="ds-share-buttons">
                 <a href="https://www.facebook.com/sharer/sharer.php?u={{ $shareUrl }}" target="_blank" class="ds-share-btn ds-share-facebook" rel="noopener"><i class="fab fa-facebook-f"></i></a>
                 <a href="https://twitter.com/intent/tweet?url={{ $shareUrl }}&text={{ $shareTitle }}" target="_blank" class="ds-share-btn ds-share-twitter" rel="noopener"><i class="fab fa-twitter"></i></a>
                 <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ $shareUrl }}&title={{ $shareTitle }}" target="_blank" class="ds-share-btn ds-share-linkedin" rel="noopener"><i class="fab fa-linkedin-in"></i></a>
                 <a href="https://wa.me/?text={{ $shareTitle }}%20{{ $shareUrl }}" target="_blank" class="ds-share-btn ds-share-whatsapp" rel="noopener"><i class="fab fa-whatsapp"></i></a>
               </div>
             </div>
           </div>
           
           <aside class="ds-service-sidebar">
             <div class="ds-sidebar-card">
               <h3>معلومات المشروع</h3>
               <ul class="ds-project-info">
                 <li><strong>الاسم:</strong> <span>{{@$portfolio->name}}</span></li>
                 <li><strong>القسم:</strong> <span>{{@$portfolio->service->name}}</span></li>
                 @if($portfolio->website)
                 <li><strong>الموقع:</strong> <a href="{{@$portfolio->website}}" target="_blank">زيارة الموقع</a></li>
                 @endif
                 @if($portfolio->android)
                 <li><strong>أندرويد:</strong> <a href="{{@$portfolio->android}}" target="_blank">تحميل التطبيق</a></li>
                 @endif
                 @if($portfolio->ios)
                 <li><strong>آيفون:</strong> <a href="{{@$portfolio->ios}}" target="_blank">تحميل التطبيق</a></li>
                 @endif
               </ul>
             </div>
             
             <div class="ds-sidebar-card">
               <h3>تصفح الخدمات</h3>
               <ul class="ds-sidebar-list">
                 @foreach($services as $other)
                 <li><a href="{{URL::to('/')}}/service/{{@str_replace(' ','_',$other->name)}}">{{@$other->name}} <i class="fas fa-chevron-left"></i></a></li>
                 @endforeach
               </ul>
             </div>
             
             <div class="ds-sidebar-cta">
               <h3>هل تريد مشروع مشابه؟</h3>
               <p>تواصل معنا الآن</p>
               <a href="{{URL::to('/contact/us')}}" class="ds-btn ds-btn-primary">تواصل معنا</a>
             </div>
           </aside>
         </div>
       </div>
     </section>
   </main>
 @stop