@extends('site.layout')
@section('metaTags')
  @php
    $seoTitle = $blog->meta_title ?: $blog->title . ' | ' . @$setting->name;
    $seoDescription = $blog->meta_description ?: strip_tags(substr($blog->content, 0, 160));
  @endphp
  <title>{{ $seoTitle }}</title>
  <meta name='description' content='{{ $seoDescription }}' />
  <meta name='keywords' content='{{@$blog->keywords}},{{@$blog->title}}' />

  <meta property="og:description" content="{{ $seoDescription }}" />
  <meta property="og:title" content="{{ $seoTitle }}" />
  <meta property="og:url" content="{{URL::to('/blog/'.str_replace(' ','_',$blog->title))}}" />
  <meta property="og:site_name" content="{{@$setting->name}}" />
  <meta property="og:image" content="{{URL::to('').@$blog->image}}">
  <meta property="og:type" content="article" />

  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{ $seoTitle }}" />
  <meta name="twitter:description" content="{{ $seoDescription }}" />
  <meta name="twitter:site" content="@bedayh4it" />
  <meta name="twitter:image" content="{{URL::to('').@$blog->image}}">

  <!-- BreadcrumbList Schema -->
  <script type="application/ld+json">
  {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
          {"@type": "ListItem", "position": 1, "name": "الرئيسية", "item": "{{ URL::to('/') }}"},
          {"@type": "ListItem", "position": 2, "name": "المدونة", "item": "{{ URL::to('/blogs') }}"},
          {"@type": "ListItem", "position": 3, "name": "{{ $blog->title }}", "item": "{{ URL::to('/blog/'.str_replace(' ','_',$blog->title)) }}"}
      ]
  }
  </script>

  <!-- Article Schema -->
  <script type="application/ld+json">
  {
      "@context": "https://schema.org",
      "@type": "Article",
      "headline": "{{ $blog->title }}",
      "description": "{{ $seoDescription }}",
      "image": "{{ URL::to('').@$blog->image }}",
      "datePublished": "{{ $blog->created_at ? $blog->created_at->toIso8601String() : now()->toIso8601String() }}",
      "dateModified": "{{ $blog->updated_at ? $blog->updated_at->toIso8601String() : now()->toIso8601String() }}",
      "author": {
          "@type": "Organization",
          "name": "{{ @$setting->name ?? 'بداية لتقنية المعلومات' }}"
      },
      "publisher": {
          "@type": "Organization",
          "name": "{{ @$setting->name ?? 'بداية لتقنية المعلومات' }}",
          "logo": {
              "@type": "ImageObject",
              "url": "{{ URL::to('').@$setting->logo }}"
          }
      },
      "mainEntityOfPage": {
          "@type": "WebPage",
          "@id": "{{ URL::to('/blog/'.str_replace(' ','_',$blog->title)) }}"
      }
  }
  </script>
@stop
 @section('content')
   <main class="main_site">
     <div class="ds-hero ds-page-hero">
       <div class="container">
         <h1 class="ds-hero-title ds-text-center">{{@$blog->title}}</h1>
         <p class="ds-breadcrumb">الرئيسية / المدونة / {{@$blog->title}}</p>
       </div>
     </div>

     <section class="ds-section">
       <div class="container">
         <div class="ds-service-layout">
           <div class="ds-service-main">
             <div class="ds-blog-featured-img">
               <img src="{{ URL::to('') }}{{@$blog->image}}" alt="{{@$blog->title}}" loading="lazy">
             </div>

             <div class="ds-service-content">
               {!! @$blog->content !!}
             </div>

             @php
               $shareUrl = urlencode(URL::to('/blog/'.str_replace(' ','_',$blog->title)));
               $shareTitle = urlencode($blog->title);
             @endphp
             <div class="ds-share-section">
               <h4>مشاركة عن طريق:</h4>
               <div class="ds-share-buttons">
                 <a href="https://www.facebook.com/sharer/sharer.php?u={{ $shareUrl }}" target="_blank" class="ds-share-btn ds-share-facebook" rel="noopener"><i class="fab fa-facebook-f"></i></a>
                 <a href="https://twitter.com/intent/tweet?url={{ $shareUrl }}&text={{ $shareTitle }}" target="_blank" class="ds-share-btn ds-share-twitter" rel="noopener"><i class="fab fa-twitter"></i></a>
                 <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ $shareUrl }}&title={{ $shareTitle }}" target="_blank" class="ds-share-btn ds-share-linkedin" rel="noopener"><i class="fab fa-linkedin-in"></i></a>
                 <a href="https://wa.me/?text={{ $shareTitle }}%20{{ $shareUrl }}" target="_blank" class="ds-share-btn ds-share-whatsapp" rel="noopener"><i class="fab fa-whatsapp"></i></a>
               </div>
             </div>
           </div>
           
           <aside class="ds-service-sidebar">
             <div class="ds-sidebar-card">
               <h3>مواضيع تهمك</h3>
               <ul class="ds-sidebar-list">
                 @foreach($blogs as $other)
                 <li><a href="{{URL::to('/')}}/blog/{{@str_replace(' ','_',$other->title)}}">{{@$other->title}} <i class="fas fa-chevron-left"></i></a></li>
                 @endforeach
               </ul>
             </div>
             
             <div class="ds-sidebar-cta">
               <h3>هل لديك استفسار؟</h3>
               <p>تواصل معنا الآن</p>
               <a href="{{URL::to('/contact/us')}}" class="ds-btn ds-btn-primary">تواصل معنا</a>
             </div>
           </aside>
         </div>
       </div>
     </section>
   </main>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
  <style>
      img {
    max-width: 100%;
    height: auto !important;
    margin-bottom:2px
}
  </style>
 @stop