@extends('site.layout')
@section('metaTags')
  @php
    $seoTitle = $service->meta_title ?: $service->name . ' | ' . @$setting->name;
    $seoDescription = $service->meta_description ?: strip_tags($service->details);
  @endphp
  <title>{{ $seoTitle }}</title>
  <meta name='description' content='{{ $seoDescription }}' />
  <meta name='keywords' content='{{@$service->keywords}},{{@$service->name}}' />

  <meta property="og:description" content="{{ $seoDescription }}" />
  <meta property="og:title" content="{{ $seoTitle }}" />
  <meta property="og:url" content="{{URL::to('/service/'.str_replace(' ','_',$service->name))}}" />
  <meta property="og:site_name" content="{{@$setting->name}}" />
  <meta property="og:image" content="{{URL::to('').@$service->icon}}">

  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{ $seoTitle }}" />
  <meta name="twitter:description" content="{{ $seoDescription }}" />
  <meta name="twitter:site" content="@bedayh4it" />
  <meta name="twitter:image" content="{{URL::to('').@$service->icon}}">

  <!-- BreadcrumbList Schema -->
  <script type="application/ld+json">
  {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
          {
              "@type": "ListItem",
              "position": 1,
              "name": "الرئيسية",
              "item": "{{ URL::to('/') }}"
          },
          {
              "@type": "ListItem",
              "position": 2,
              "name": "خدماتنا",
              "item": "{{ URL::to('/') }}/#services"
          },
          {
              "@type": "ListItem",
              "position": 3,
              "name": "{{ $service->name }}",
              "item": "{{ URL::to('/service/'.str_replace(' ','_',$service->name)) }}"
          }
      ]
  }
  </script>
@stop
 @section('content')
   <main class="main_site">
     <div class="ds-hero ds-page-hero">
       <div class="container">
         <h1 class="ds-hero-title ds-text-center">{{@$service->name}}</h1>
         <p class="ds-breadcrumb">الرئيسية / خدماتنا / {{@$service->name}}</p>
       </div>
     </div>
     <section class="ds-section">
       <div class="container">
         <div class="ds-service-layout">
           <div class="ds-service-main">
             <div class="ds-service-image">
               <img src="{{URL::to('/')}}{{@$service->icon}}" alt="{{@$service->name}}" loading="lazy">
             </div>
             
             <div class="ds-service-content">
               {!! @$service->content !!}
             </div>

             @php
               $shareUrl = urlencode(URL::to('/service/'.str_replace(' ','_',$service->name)));
               $shareTitle = urlencode($service->name);
             @endphp
             <div class="ds-share-section">
               <h4>مشاركة عن طريق:</h4>
               <div class="ds-share-buttons">
                 <a href="https://www.facebook.com/sharer/sharer.php?u={{ $shareUrl }}" target="_blank" class="ds-share-btn ds-share-facebook" rel="noopener"><i class="fab fa-facebook-f"></i></a>
                 <a href="https://twitter.com/intent/tweet?url={{ $shareUrl }}&text={{ $shareTitle }}" target="_blank" class="ds-share-btn ds-share-twitter" rel="noopener"><i class="fab fa-twitter"></i></a>
                 <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ $shareUrl }}&title={{ $shareTitle }}" target="_blank" class="ds-share-btn ds-share-linkedin" rel="noopener"><i class="fab fa-linkedin-in"></i></a>
                 <a href="https://wa.me/?text={{ $shareTitle }}%20{{ $shareUrl }}" target="_blank" class="ds-share-btn ds-share-whatsapp" rel="noopener"><i class="fab fa-whatsapp"></i></a>
               </div>
             </div>
           </div>
           
           <aside class="ds-service-sidebar">
             <div class="ds-sidebar-card">
               <h3>تصفح الخدمات الأخرى</h3>
               <ul class="ds-sidebar-list">
                 @foreach($services as $other)
                 <li><a href="{{URL::to('/')}}/service/{{@str_replace(' ','_',$other->name)}}">{{@$other->name}} <i class="fas fa-chevron-left"></i></a></li>
                 @endforeach
               </ul>
             </div>
             
             <div class="ds-sidebar-cta">
               <h3>هل تحتاج هذه الخدمة؟</h3>
               <p>تواصل معنا الآن للحصول على عرض سعر مخصص</p>
               <a href="{{URL::to('/contact/us')}}" class="ds-btn ds-btn-primary">تواصل معنا</a>
             </div>
           </aside>
         </div>
       </div>
     </section>
   </main>

 @stop