@extends('site.layout')
@section('metaTags')
  <title> أعمالنا | {{@$setting->name}}    </title>
  <meta name='description' itemprop='description' content='{{ @$setting->description }}' />
  <meta name='keywords' content='{{@$info->keywords}},{{ @$setting->description }},{{ @$setting->name.','.@strip_tags($info->content_ar)}}' />
  <meta property='article:section' content='{{@strip_tags($info->content_ar)}}' />

  <meta property="og:description"content="{{@strip_tags($info->content_ar)}}" />
  <meta property="og:title"content=" {{@$setting->name}}  | أعمالنا " />
  <meta property="og:url"content="{{URL::to('/portfolio')}}" />
  <meta property="og:site_name"content="{{@$setting->name}} " />
  <meta property="og:image" content="{{URL::to('').@$info->file}}">

  <meta name="twitter:card"content="summary" />
  <meta name="twitter:title"content=" {{@$setting->name}}  | أعمالنا " />
  <meta name="twitter:site"content="bedayh4it.com" />
@stop
 @section('content')
  <main class="main_site" id="home">
      <div class="ds-hero ds-page-hero">
        <div class="container">
          <h1 class="ds-hero-title ds-text-center">أعمالنا</h1>
          <p class="ds-breadcrumb">الرئيسية / أعمالنا</p>
        </div>
      </div>
      <!--========== start portfolio =============-->
      <section class="ds-section text-center">
        <div class="container">
          <div class="ds-filter-buttons ds-mb-6">
            <button class="ds-filter-btn active" data-rel="all">الجميع</button>
            @foreach($services as $service)
             <button class="ds-filter-btn" data-rel="{{@$service->name.$service->id}}">{{@$service->name}}</button>
            @endforeach
          </div>
          <div id="portfolio_items">
            <div class="ds-grid ds-grid-3">
              @foreach($projects as $project)
              <div class="portfolio_item {{@$project->service->name.@$project->service->id}} all">
                <a href="{{URL::to('/')}}/portfolio/{{@str_replace(' ','_',$project->name)}}" class="ds-card ds-portfolio-card">
                  <div class="ds-portfolio-img">
                    <img src="{{URL::to('/')}}{{@$project->images()->first()->image}}" alt="{{@$project->name}}" loading="lazy">
                  </div>
                  <div class="ds-portfolio-content">
                    <h3>{{@$project->name}}</h3>
                  </div>
                </a>
              </div>
              @endforeach
            </div> 
          </div>
        </div>
      </section>
    </main>
@stop