@inject('footerServices', 'App\Service')
@inject('footerSetting', 'App\ContactUsSetting')
<!Doctype html>
<html lang="ar-sa" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="alternate" href="https://bedayh4it.com" hreflang="ar-sa" />
    <link rel="canonical" href="{{ url()->current() }}" />
    <meta name="google-site-verification" content="XGerpiftRcOKmEbPHpHhjcaXuUfsrFT7HBOKNFdnIlw" />
    <meta name="robots" content="index, follow">
    <meta name="author" content="Bedayah IT">
    @yield('metaTags')
    
    <!-- Schema.org Organization Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "{{ @$setting->name ?? 'بداية لتقنية المعلومات' }}",
        "url": "https://bedayh4it.com",
        "logo": "{{ URL::to('').@$setting->logo }}",
        "description": "{{ @$setting->description ?? 'شركة رائدة في تصميم المواقع وتطبيقات الجوال' }}",
        "address": {
            "@type": "PostalAddress",
            "addressLocality": "Riyadh",
            "addressCountry": "SA"
        },
        "contactPoint": {
            "@type": "ContactPoint",
            "telephone": "{{ @$setting->phone ?? '' }}",
            "contactType": "customer service",
            "email": "{{ @$setting->email ?? '' }}",
            "availableLanguage": ["Arabic", "English"]
        },
        "sameAs": [
            "{{ @$setting->fburl ?? '' }}",
            "{{ @$setting->twitter_url ?? '' }}",
            "{{ @$setting->instagram ?? '' }}"
        ]
    }
    </script>
    
    <!-- Schema.org LocalBusiness Markup with ContactPoint -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "LocalBusiness",
        "name": "{{ @$setting->name ?? 'بداية لتقنية المعلومات' }}",
        "image": "{{ URL::to('').@$setting->logo }}",
        "url": "https://bedayh4it.com",
        "telephone": "{{ @$setting->phone ?? '' }}",
        "email": "{{ @$setting->email ?? '' }}",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "{{ @$setting->address ?? 'Riyadh' }}",
            "addressLocality": "Riyadh",
            "addressCountry": "SA"
        },
        "priceRange": "$$",
        "contactPoint": [
            {
                "@type": "ContactPoint",
                "telephone": "{{ @$setting->phone ?? '' }}",
                "contactType": "customer service",
                "availableLanguage": ["Arabic", "English"],
                "areaServed": "SA"
            },
            {
                "@type": "ContactPoint",
                "telephone": "{{ @$setting->whatsapp ?? @$setting->phone ?? '' }}",
                "contactType": "sales",
                "availableLanguage": ["Arabic", "English"],
                "areaServed": "SA"
            }
        ],
        "sameAs": [
            "{{ @$setting->fburl ?? '' }}",
            "{{ @$setting->twitter_url ?? '' }}",
            "{{ @$setting->instgram_url ?? '' }}",
            "{{ @$setting->linkedin_url ?? '' }}"
        ]
    }
    </script>
    
    <!-- Favicons -->
    @if(isset($setting))
    <link rel="icon" href="{{URL::to('').@$setting->logo}}" sizes="16x16" type="image/png">
    <link rel="apple-touch-icon" href="{{URL::to('').@$setting->logo}}">
    @endif

    <!-- Preload critical fonts for performance -->
    <link rel="preload" href="{{ URL::to('/') }}/assets/site/fonts/JFFlat-Regular.ttf" as="font" type="font/ttf" crossorigin>
    
    <!-- Preconnect to external resources -->
    <link rel="preconnect" href="https://maxcdn.bootstrapcdn.com">
    <link rel="preconnect" href="https://ajax.googleapis.com">
    <link rel="dns-prefetch" href="https://www.googletagmanager.com">
    
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
    <link href="{{ URL::to('/') }}/assets/site/css/bootstrap-rtl.css" rel="stylesheet" type="text/css"/>

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="{{ URL::to('/') }}/assets/site/css/inc/plugins.css">
    <!-- CSS Global Compulsory -->
    
    <link rel="stylesheet" href="{{ URL::to('/') }}/assets/site/css/style.css">
    
    <!-- Design System -->
    <link rel="stylesheet" href="{{ URL::to('/') }}/assets/site/css/design-system.css">
    
    <!-- Google Fonts - Tajawal for Arabic -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700;800&display=swap" rel="stylesheet">
    
    <!-- Font display swap for better performance -->
    <style>
    @font-face {
        font-family: 'JFFlat';
        src: url('{{ URL::to('/') }}/assets/site/fonts/JFFlat-Regular.ttf') format('truetype');
        font-display: swap;
    }
    </style>
  <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-6629319857217526"
     crossorigin="anonymous"></script>
     
  </head>
  <body>
    <!-- Skip to main content link for accessibility -->
    <a href="#main-content" class="skip-link">تخطي إلى المحتوى الرئيسي</a>
      
    <header class="site_header ds-header fixed-top w-100" role="banner">
      <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light" role="navigation" aria-label="القائمة الرئيسية">
          @if(isset($setting))
          <a class="navbar-brand" href="{{ URL::to('/') }}">
            <img src="{{URL::to('').@$setting->logo}}" width="55" alt="{{@$setting->name}}" class="ds-logo">
          </a>
          @endif
          <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
            <i class="fas fa-bars"></i>
          </button>
          <div class="collapse navbar-collapse ml-auto" id="navbarNavAltMarkup">
            <div class="navbar-nav">
              <a class="nav-item nav-link ds-nav-link active" href="{{ URL::to('/') }}">الرئيسية</a>
              <a class="nav-item nav-link ds-nav-link" href="{{ URL::to('about_us') }}">من نحن</a>
              
              <!-- Services Dropdown -->
              <div class="ds-dropdown">
                <a class="nav-item nav-link ds-nav-link ds-dropdown-toggle" href="@if(Request::route() && Request::route()->getName()=='home'){{ URL::to('/') }}/#services @else {{ URL::to('/') }}/#services @endif">
                  خدماتنا <i class="fas fa-chevron-down"></i>
                </a>
                <div class="ds-dropdown-menu">
                  @foreach($menuservices ?? [] as $service)
                  <a class="ds-dropdown-item" href="{{URL::to('/')}}/service/{{@str_replace(' ','_',$service->name)}}">{{ $service->name }}</a>
                  @endforeach
                </div>
              </div>
              
              <a class="nav-item nav-link ds-nav-link" href="@if(Request::route() && Request::route()->getName()=='home'){{ URL::to('/') }}/#portfolio @else {{ URL::to('/') }}/portfolio @endif">اعمالنا</a>
              <a class="nav-item nav-link ds-nav-link" href="@if(Request::route() && Request::route()->getName()=='home'){{ URL::to('/') }}/#pricing @else {{ URL::to('/') }}/#pricing @endif">الاستضافة</a>
              <a class="nav-item nav-link ds-nav-link" href="{{URL::to('/blogs')}}">المدونة</a>
              <a class="nav-item nav-link ds-nav-link ds-nav-cta" href="{{URL::to('/contact/us')}}">اتصل بنا</a>
            </div>
          </div>
        </nav>
      </div>
    </header>



       <main id="main-content" role="main">
       @yield('content')
    </main>
     
         <a href="https://wa.me/+201022162396" target="_blank" rel="noopener noreferrer" aria-label="تواصل معنا عبر واتساب - الرقم الأول" style="position: fixed; left: 0px; bottom: 5px; z-index: 906; min-width: 35px; padding: 15px 30px; border-radius: 36px 0px; font-weight: bold; font-size: 12px; line-height: 1.5; text-align: center; letter-spacing: 1.3px; color: #fff; text-transform: uppercase; word-break: break-word;">
            <img src="{{asset('img/whatsapp.png')}}" width="50" height="50" alt="واتساب">
        </a> 
        
        <a href="https://wa.me/+201061637022" target="_blank" rel="noopener noreferrer" aria-label="تواصل معنا عبر واتساب - الرقم الثاني" style="position: fixed; left: 0px; bottom: 50px; z-index: 906; min-width: 35px; padding: 15px 30px; border-radius: 36px 0px; font-weight: bold; font-size: 12px; line-height: 1.5; text-align: center; letter-spacing: 1.3px; color: #fff; text-transform: uppercase; word-break: break-word;">
            <img src="{{asset('img/whatsapp.png')}}" width="50" height="50" alt="واتساب">
        </a> 
    <!--========== start footer section =============-->
    <footer class="site_footer ds-footer">
      <div class="container">
        <h3 class="text-center ds-text-white ds-mb-8"><span>بداية لتقنية المعلومات خيارك الامثل للارتقاء بأعمالك</span></h3>
        
        <div class="row">
          <!-- Contact Info Column -->
          @php $footerSettingData = $setting ?? $footerSetting::first(); @endphp
          <div class="col-sm-12 col-md-4 col-lg-4">
            <h2 class="ds-footer-title">معلومات التواصل</h2>
            <div class="contact_info text-right" itemscope itemtype="https://schema.org/LocalBusiness">
              <meta itemprop="name" content="{{ @$footerSettingData->name }}">
              <div class="ds-footer-link" itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
                <i class="fas fa-map-marker-alt"></i>
                <span itemprop="streetAddress">{{@$footerSettingData->address}}</span>
                <meta itemprop="addressLocality" content="Riyadh">
                <meta itemprop="addressCountry" content="SA">
              </div>
              <div class="ds-footer-link">
                <i class="far fa-envelope"></i>
                <a href="mailto:{{@$footerSettingData->email}}" itemprop="email">{{@$footerSettingData->email}}</a>
              </div>
              <div class="ds-footer-link">
                <i class="fas fa-mobile-alt"></i>
                <a href="tel:{{@$footerSettingData->phone}}" itemprop="telephone">{{@$footerSettingData->phone}}</a>
              </div>
              <div class="ds-social-icons ds-mt-4">
                <a href="{{@$footerSettingData->fburl}}" target="_blank" class="ds-social-icon" aria-label="Facebook">
                  <i class="fab fa-facebook-f"></i>
                </a>
                <a href="{{@$footerSettingData->twitter_url}}" target="_blank" class="ds-social-icon" aria-label="Twitter">
                  <i class="fab fa-twitter"></i>
                </a>
                <a href="{{@$footerSettingData->instgram_url}}" target="_blank" class="ds-social-icon" aria-label="Instagram">
                  <i class="fab fa-instagram"></i>
                </a>
                <a href="{{@$footerSettingData->linkedin_url}}" target="_blank" class="ds-social-icon" aria-label="LinkedIn">
                  <i class="fab fa-linkedin-in"></i>
                </a>
                <a href="{{@$footerSettingData->youtube_url}}" target="_blank" class="ds-social-icon" aria-label="YouTube">
                  <i class="fab fa-youtube"></i>
                </a>
              </div>
            </div>
          </div>
          
          <!-- About Links Column -->
          <div class="col-sm-12 col-md-4 col-lg-4">
            <h2 class="ds-footer-title">معلومات عنا</h2>
            <div class="contact_info">
              <a class="ds-footer-link" href="{{ URL::to('about_us') }}">من نحن</a>
              <a class="ds-footer-link" href="{{ URL::to('/') }}/#services">خدماتنا</a>
              <a class="ds-footer-link" href="{{ URL::to('/') }}/#portfolio">اعمالنا</a>
              <a class="ds-footer-link" href="{{ URL::to('/') }}/#pricing">الاستضافة</a>
              <a class="ds-footer-link" href="{{URL::to('/contact/us')}}">اتصل بنا</a>
            </div>
          </div>
          
          <!-- Services Column -->
          <div class="col-sm-12 col-md-4 col-lg-4">
            <h2 class="ds-footer-title">خدماتنا</h2>
            <div class="ds-footer-links">
              @foreach($services ?? $footerServices::all() as $service)
              <a href="{{URL::to('/')}}/service/{{@str_replace(' ','_',$service->name)}}">{{@$service->name}}</a>
              @endforeach
            </div>
          </div>
        </div>
        
        <p class="ds-text-center ds-mt-8">جميع الحقوق محفوظه &copy; {{ date('Y') }} {{@$setting->name}}</p>
      </div>
    </footer>



    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
    <script src="{{ URL::to('/') }}/assets/site/js/jQuery-plugins.js"></script>
    <script src="{{ URL::to('/') }}/assets/site/js/scripts.js"></script>
   {{-- Google Analytics 4 --}}
  <!-- Google tag (gtag.js) - GA4 -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-XXXXXXXXXX"></script>
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', 'G-XXXXXXXXXX');
    
    // Track conversions
    function trackConversion(eventName, eventParams) {
        gtag('event', eventName, eventParams);
    }
    
    // Track phone clicks
    document.querySelectorAll('a[href^="tel:"]').forEach(function(el) {
        el.addEventListener('click', function() {
            trackConversion('phone_click', { 'event_category': 'contact' });
        });
    });
    
    // Track WhatsApp clicks
    document.querySelectorAll('a[href*="wa.me"]').forEach(function(el) {
        el.addEventListener('click', function() {
            trackConversion('whatsapp_click', { 'event_category': 'contact' });
        });
    });
    
    // Track email clicks
    document.querySelectorAll('a[href^="mailto:"]').forEach(function(el) {
        el.addEventListener('click', function() {
            trackConversion('email_click', { 'event_category': 'contact' });
        });
    });
  </script>
  {{-- End Google Analytics 4 --}}
    <!--Start of Tawk.to Script-->
    <script src="{{ asset('js/share.js') }}"></script>
    
    <!-- Carousel Functions -->
    <script>
    // Carousel state
    const carouselState = {};
    
    // Initialize carousels - faster auto-scroll (3 seconds)
    document.addEventListener('DOMContentLoaded', function() {
        initCarousel('services-carousel', 3000);
        initCarousel('portfolio-carousel', 3500);
        initCarousel('pricing-carousel', 4000);
    });
    
    function initCarousel(carouselId, autoPlayInterval) {
        const carousel = document.getElementById(carouselId);
        if (!carousel) return;
        
        const pages = carousel.querySelectorAll('.ds-carousel-page');
        const dotsContainer = document.getElementById(carouselId.replace('-carousel', '-dots'));
        
        if (pages.length <= 1) return;
        
        carouselState[carouselId] = {
            currentPage: 0,
            totalPages: pages.length,
            autoPlayInterval: autoPlayInterval
        };
        
        // Create dots
        if (dotsContainer) {
            for (let i = 0; i < pages.length; i++) {
                const dot = document.createElement('span');
                dot.className = 'ds-carousel-dot' + (i === 0 ? ' active' : '');
                dot.onclick = function() { goToPage(carouselId, i); };
                dotsContainer.appendChild(dot);
            }
        }
        
        // Auto-play
        startAutoPlay(carouselId);
        
        // Pause on hover
        carousel.addEventListener('mouseenter', function() {
            stopAutoPlay(carouselId);
        });
        carousel.addEventListener('mouseleave', function() {
            startAutoPlay(carouselId);
        });
    }
    
    function carouselNext(carouselId) {
        const state = carouselState[carouselId];
        if (!state) return;
        const nextPage = (state.currentPage + 1) % state.totalPages;
        goToPage(carouselId, nextPage);
    }
    
    function carouselPrev(carouselId) {
        const state = carouselState[carouselId];
        if (!state) return;
        const prevPage = (state.currentPage - 1 + state.totalPages) % state.totalPages;
        goToPage(carouselId, prevPage);
    }
    
    function goToPage(carouselId, pageIndex) {
        const carousel = document.getElementById(carouselId);
        if (!carousel) return;
        
        const pages = carousel.querySelectorAll('.ds-carousel-page');
        const dots = carousel.parentElement.querySelectorAll('.ds-carousel-dot');
        
        pages.forEach((page, i) => {
            page.classList.toggle('active', i === pageIndex);
        });
        
        dots.forEach((dot, i) => {
            dot.classList.toggle('active', i === pageIndex);
        });
        
        carouselState[carouselId].currentPage = pageIndex;
    }
    
    function startAutoPlay(carouselId) {
        const state = carouselState[carouselId];
        if (!state) return;
        
        state.timer = setInterval(function() {
            carouselNext(carouselId);
        }, state.autoPlayInterval);
    }
    
    function stopAutoPlay(carouselId) {
        const state = carouselState[carouselId];
        if (state && state.timer) {
            clearInterval(state.timer);
        }
    }
    
    // About Us Tabs Function
    document.addEventListener('DOMContentLoaded', function() {
        // Tabs functionality
        const tabBtns = document.querySelectorAll('.ds-tab-btn');
        tabBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                const tabId = this.getAttribute('data-tab');
                
                // Remove active from all buttons and contents
                document.querySelectorAll('.ds-tab-btn').forEach(b => b.classList.remove('active'));
                document.querySelectorAll('.ds-tab-content').forEach(c => c.classList.remove('active'));
                
                // Add active to clicked button and corresponding content
                this.classList.add('active');
                const content = document.getElementById('tab-' + tabId);
                if (content) content.classList.add('active');
            });
        });
        
        // Stats Counter Animation
        const statNumbers = document.querySelectorAll('.ds-stat-number');
        if (statNumbers.length > 0) {
            const animateCounter = (el) => {
                const target = parseInt(el.getAttribute('data-count'));
                const duration = 2000;
                const step = target / (duration / 16);
                let current = 0;
                
                const timer = setInterval(() => {
                    current += step;
                    if (current >= target) {
                        el.textContent = target + '+';
                        clearInterval(timer);
                    } else {
                        el.textContent = Math.floor(current);
                    }
                }, 16);
            };
            
            // Intersection Observer for stats section
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        statNumbers.forEach(el => animateCounter(el));
                        observer.disconnect();
                    }
                });
            }, { threshold: 0.5 });
            
            const statsSection = document.querySelector('.ds-stats-section');
            if (statsSection) observer.observe(statsSection);
        }
    });
    
    // Portfolio Filter Function
    function filterPortfolio(category) {
        // Update active button
        document.querySelectorAll('.ds-filter-btn').forEach(btn => {
            btn.classList.remove('active');
            if (btn.getAttribute('data-rel') === category) {
                btn.classList.add('active');
            }
        });
        
        // Filter items
        const items = document.querySelectorAll('#portfolio-carousel .ds-portfolio-card');
        items.forEach(item => {
            const parent = item.closest('.ds-grid-6 > a') || item;
            if (category === 'all') {
                parent.style.display = '';
            } else {
                // Check if item belongs to category
                const wrapper = item.closest('[class*="' + category + '"]');
                if (wrapper || item.closest('.ds-grid-6').querySelector('[class*="' + category + '"]')) {
                    parent.style.display = '';
                } else {
                    parent.style.display = 'none';
                }
            }
        });
    }
    </script>
    <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        (function(){
            var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
            s1.async=true;
            s1.src='https://embed.tawk.to/5c9fe6001de11b6e3b0608e8/default';
            s1.charset='UTF-8';
            s1.setAttribute('crossorigin','*');
            s0.parentNode.insertBefore(s1,s0);
        })();
    </script>
   

    <!--End of Tawk.to Script-->

    <!-- Floating WhatsApp Button -->
    @if(isset($setting) && $setting->whatsapp)
    <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $setting->whatsapp) }}?text={{ urlencode('مرحباً، أريد الاستفسار عن خدماتكم') }}" 
       class="whatsapp-float" 
       target="_blank" 
       rel="noopener noreferrer"
       aria-label="تواصل معنا عبر واتساب">
        <i class="fab fa-whatsapp"></i>
    </a>
    @endif

    <!-- Floating Call Button (Mobile Only) -->
    @if(isset($setting) && $setting->phone)
    <a href="tel:{{ $setting->phone }}" 
       class="call-float d-md-none" 
       aria-label="اتصل بنا">
        <i class="fas fa-phone-alt"></i>
    </a>
    @endif

    <style>
    /* WhatsApp Floating Button */
    .whatsapp-float {
        position: fixed;
        width: 60px;
        height: 60px;
        bottom: 100px;
        left: 20px;
        background-color: #25D366;
        color: #fff;
        border-radius: 50%;
        text-align: center;
        font-size: 30px;
        box-shadow: 2px 2px 10px rgba(0,0,0,0.3);
        z-index: 9999;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }
    .whatsapp-float:hover {
        background-color: #128C7E;
        color: #fff;
        transform: scale(1.1);
    }
    
    /* Call Floating Button (Mobile) */
    .call-float {
        position: fixed;
        width: 60px;
        height: 60px;
        bottom: 20px;
        left: 20px;
        background-color: #007bff;
        color: #fff;
        border-radius: 50%;
        text-align: center;
        font-size: 24px;
        box-shadow: 2px 2px 10px rgba(0,0,0,0.3);
        z-index: 9999;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }
    .call-float:hover {
        background-color: #0056b3;
        color: #fff;
        transform: scale(1.1);
    }
    
    /* Skip to main content link for accessibility */
    .skip-link {
        position: absolute;
        top: -40px;
        left: 0;
        background: #000;
        color: #fff;
        padding: 8px 16px;
        z-index: 10000;
        text-decoration: none;
        border-radius: 0 0 4px 4px;
    }
    .skip-link:focus {
        top: 0;
        outline: 2px solid #007bff;
    }
    
    /* Focus indicators for accessibility */
    a:focus, button:focus, input:focus, select:focus, textarea:focus {
        outline: 2px solid #007bff;
        outline-offset: 2px;
    }
    
    .nav-link:focus {
        outline: 2px solid #007bff;
        outline-offset: 2px;
        background-color: rgba(0, 123, 255, 0.1);
        border-radius: 4px;
    }
    
    .btn:focus {
        outline: 2px solid #007bff;
        outline-offset: 2px;
        box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    }
    
    /* Reduced motion for accessibility */
    @media (prefers-reduced-motion: reduce) {
        *, *::before, *::after {
            animation-duration: 0.01ms !important;
            animation-iteration-count: 1 !important;
            transition-duration: 0.01ms !important;
        }
    }
    </style>

    <!-- Modern UI Enhancements -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Header scroll effect
        var header = document.querySelector('.site_header');
        var scrollThreshold = 50;
        
        function handleScroll() {
            if (window.scrollY > scrollThreshold) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        }
        
        window.addEventListener('scroll', handleScroll, { passive: true });
        handleScroll();
        
        // Animate elements on scroll
        var animateElements = document.querySelectorAll('.animate-on-scroll');
        var observer = new IntersectionObserver(function(entries) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    entry.target.classList.add('animate-fadeInUp');
                    observer.unobserve(entry.target);
                }
            });
        }, { threshold: 0.1, rootMargin: '0px 0px -50px 0px' });
        
        animateElements.forEach(function(el) { observer.observe(el); });
        
        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(function(anchor) {
            anchor.addEventListener('click', function(e) {
                var targetId = this.getAttribute('href');
                if (targetId !== '#') {
                    var target = document.querySelector(targetId);
                    if (target) {
                        e.preventDefault();
                        target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }
                }
            });
        });
    });
    </script>

  </body>
</html>
