@extends('site.layout')
@section('metaTags')
<title>{{@$setting->name}} | الرئيسية - تصميم مواقع وتطبيقات الجوال</title>
<meta name='description' content='{{ strip_tags(@$setting->description) }}' />
<meta name='keywords' content='{{@$setting->meta_tags}},تصميم مواقع,تطبيقات جوال,برمجة,استضافة,تسويق رقمي' />
<meta property="fb:app_id" content="409276206400173" />
<meta property="og:title" content="{{@$setting->name}} | الرئيسية" />
<meta property="og:description" content="{{ strip_tags(@$setting->description) }}" />
<meta property="og:type" content="website" />
<meta property="og:url" content="{{URL::to('/')}}" />
<meta property="og:image" content="{{URL::to('').@$setting->logo}}">
<meta property="og:site_name" content="{{@$setting->name}}" />
<meta property="og:locale" content="ar_SA" />

<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:site" content="@bedayh4it" />
<meta name="twitter:title" content="{{@$setting->name}}" />
<meta name="twitter:description" content="{{ strip_tags(@$setting->description) }}" />
<meta name="twitter:image" content="{{URL::to('').@$setting->logo}}" />

<!-- Service Schema for Homepage -->
@if(isset($services) && count($services) > 0)
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "ItemList",
    "name": "خدماتنا",
    "itemListElement": [
        @foreach($services as $index => $service)
        {
            "@type": "ListItem",
            "position": {{ $index + 1 }},
            "item": {
                "@type": "Service",
                "name": "{{ $service->name }}",
                "description": "{{ strip_tags($service->details) }}",
                "url": "{{ URL::to('/') }}/service/{{ str_replace(' ', '_', $service->name) }}",
                "provider": {
                    "@type": "Organization",
                    "name": "{{ @$setting->name }}"
                }
            }
        }@if(!$loop->last),@endif
        @endforeach
    ]
}
</script>
@endif

@stop
@section('content')
<main class="main_site" id="home">
  <!--========== start hero section =============-->

  <section id="hero_section" class="ds-hero">
    <!-- Decorative Elements - Floating Circles -->
    <div class="hero-circles">
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
    </div>
    <div class="hero-decoration"></div>
    
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12 col-lg-6 padding_right">
          <div class="hero_content ds-animate-fadeInUp">
            <h1 class="ds-hero-title">ابدأ مشروعك مع شركة بداية لتقنية المعلومات</h1>
            <p class="ds-hero-desc">شركة رائدة في مجال تصميم المواقع وتطبيقات الجوال والتسويق الرقمي</p>
            <div class="hero-buttons" style="display: flex; gap: 1rem; flex-wrap: wrap;">
              <a href="#services" class="ds-btn ds-btn-secondary ds-btn-lg">اكتشف خدماتنا</a>
              <a href="{{ URL::to('/contact/us') }}" class="ds-btn ds-btn-outline ds-btn-lg">تواصل معنا</a>
            </div>
            
            <!-- Trust Indicators -->
            <div class="ds-trust-indicators">
              <div class="ds-trust-item">
                <span class="ds-trust-number">500+</span>
                <span class="ds-trust-label">مشروع منجز</span>
              </div>
              <div class="ds-trust-item">
                <span class="ds-trust-number">10+</span>
                <span class="ds-trust-label">سنوات خبرة</span>
              </div>
              <div class="ds-trust-item">
                <span class="ds-trust-number">100%</span>
                <span class="ds-trust-label">رضا العملاء</span>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-12 col-lg-6">
          <div class="hero_img text-center ds-animate-fadeInUp">
            <img src="{{ URL::to('/') }}/assets/site/img/bedayh_slide.png" alt="شركة بداية لتقنية المعلومات" class="ds-hero-img" loading="eager">
          </div>
        </div>
      </div>
    </div>
  </section>
  <!--========== start services section =============-->
@if(count($services) > 0 )
  <section id="services" class="ds-section ds-section-alt text-center">
    <div class="container">
      <h2 class="ds-section-title">خدماتنا</h2>
      <p class="ds-section-desc">نسعى في بداية لتقنية المعلومات لتلبية احتياجات عملائنا من خلال أفضل الخدمات وأحدث التقنيات المستخدمة بجودة عالية وبأقل تكلفة ممكنة</p>
      
      <div class="ds-carousel" id="services-carousel">
        @if($services->count() > 6)
        <div class="ds-carousel-nav">
          <button class="ds-carousel-btn ds-carousel-prev" onclick="carouselPrev('services-carousel')"><i class="fas fa-chevron-right"></i></button>
          <button class="ds-carousel-btn ds-carousel-next" onclick="carouselNext('services-carousel')"><i class="fas fa-chevron-left"></i></button>
        </div>
        @endif
        <div class="ds-carousel-inner">
          @foreach($services->chunk(6) as $pageIndex => $chunk)
          <div class="ds-carousel-page {{ $pageIndex == 0 ? 'active' : '' }}">
            <div class="ds-grid-6">
              @foreach($chunk as $service)
              <a href="{{URL::to('/')}}/service/{{@str_replace(' ','_',$service->name)}}" class="ds-card ds-service-card">
                <img src="{{URL::to('')}}{{$service->icon}}" alt="{{ $service->name }}" class="ds-card-icon" loading="lazy">
                <h3 class="ds-card-title">{{ $service->name }}</h3>
                <p class="ds-card-desc">{{@$service->details}}</p>
              </a>
              @endforeach
            </div>
          </div>
          @endforeach
        </div>
        @if($services->count() > 6)
        <div class="ds-carousel-dots-container">
          <div class="ds-carousel-dots" id="services-dots"></div>
        </div>
        @endif
      </div>
    </div>
  </section>
  @endif

      @if(count($projects) > 0)
      <section id="portfolio" class="ds-section text-center">
        <div class="container">
          <h2 class="ds-section-title">أعمالنا</h2>
          <p class="ds-section-desc">أعمال نفتخر بها</p>
          
          <!-- Portfolio Filter Buttons -->
          <div class="ds-filter-buttons ds-mb-6">
            <button class="ds-filter-btn active" data-rel="all" onclick="filterPortfolio('all')">الجميع</button>
            @foreach($services as $service)
            <button class="ds-filter-btn" data-rel="{{@str_replace(' ','_',$service->name).@$service->id}}" onclick="filterPortfolio('{{@str_replace(' ','_',$service->name).@$service->id}}')">{{@$service->name}}</button>
            @endforeach
          </div>
          
          <div class="ds-carousel" id="portfolio-carousel">
            @if($projects->count() > 6)
            <div class="ds-carousel-nav">
              <button class="ds-carousel-btn ds-carousel-prev" onclick="carouselPrev('portfolio-carousel')"><i class="fas fa-chevron-right"></i></button>
              <button class="ds-carousel-btn ds-carousel-next" onclick="carouselNext('portfolio-carousel')"><i class="fas fa-chevron-left"></i></button>
            </div>
            @endif
            <div class="ds-carousel-inner">
              @foreach($projects->chunk(6) as $pageIndex => $chunk)
              <div class="ds-carousel-page {{ $pageIndex == 0 ? 'active' : '' }}">
                <div class="ds-grid-6">
                  @foreach($chunk as $project)
                  <a href="{{URL::to('/')}}/portfolio/{{@str_replace(' ','_',$project->name)}}" class="ds-card ds-portfolio-card">
                    <div class="ds-portfolio-img">
                      <img src="{{URL::to('/')}}{{@$project->images()->first()->image}}" alt="{{@$project->name}}" loading="lazy">
                    </div>
                    <div class="ds-portfolio-content">
                      <h3>{{@$project->name}}</h3>
                    </div>
                  </a>
                  @endforeach
                </div>
              </div>
              @endforeach
            </div>
            @if($projects->count() > 6)
            <div class="ds-carousel-dots-container">
              <div class="ds-carousel-dots" id="portfolio-dots"></div>
            </div>
            @endif
          </div>

          <a class="ds-btn ds-btn-primary ds-btn-lg ds-mt-8" href="{{ URL::to('/') }}/portfolio">المزيد من الأعمال</a>
        </div>
      </section>
      @endif
    
      @if(count($hosts) > 0)
      <section id="pricing" class="ds-section ds-section-alt text-center">
        <div class="container">
          <h2 class="ds-section-title">باقات الاستضافة</h2>
          <p class="ds-section-desc">تفرغ لإدارة موقعك حيث الاستقرار والأمان مع خدمة الاستضافة من شركة بداية لتقنية المعلومات</p>
          
          <div class="ds-pricing-grid">
            @foreach($hosts as $index => $host)
            <div class="ds-pricing-card {{ $index == 1 ? 'featured' : '' }}">
              <h3 class="ds-pricing-name">{{ $host->name }}</h3>
              <div class="ds-pricing-price">{{ $host->price }}</div>
              <ul class="ds-pricing-features">
                <li><span>المساحة</span> <strong>{{ $host->space }}</strong></li>
                <li><span>عدد الإيميلات</span> <strong>{{ $host->email }}</strong></li>
                <li><span>الباندويث</span> <strong>{{ $host->bandwidth }}</strong></li>
                <li><span>نطاقات فرعية</span> <strong>{{ $host->subdomains }}</strong></li>
                <li><span>نطاق أساسي</span> <strong>{{ $host->domains }}</strong></li>
              </ul>
              <a href="{{URL::to('/contact/us')}}" class="ds-btn ds-btn-primary">احجز الآن</a>
            </div>
            @endforeach
          </div>
        </div>
      </section>
      @endif
   
  @stop
