@extends('site.layout')
@section('metaTags')
<title>الأسئلة الشائعة | {{ @$setting->name }}</title>
<meta name='description' content='إجابات على الأسئلة الشائعة حول خدمات بداية لتقنية المعلومات - تصميم المواقع، تطبيقات الجوال، التسويق الرقمي، والاستضافة' />
<meta name='keywords' content='أسئلة شائعة,تصميم مواقع,تطبيقات جوال,استضافة,تسويق رقمي,بداية لتقنية المعلومات' />

<meta property="og:title" content="الأسئلة الشائعة | {{ @$setting->name }}" />
<meta property="og:description" content="إجابات على الأسئلة الشائعة حول خدماتنا" />
<meta property="og:type" content="website" />
<meta property="og:url" content="{{ URL::to('/faq') }}" />

<!-- FAQ Schema -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
        {
            "@type": "Question",
            "name": "ما هي خدمات بداية لتقنية المعلومات؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "نقدم خدمات متكاملة تشمل: تصميم وبرمجة المواقع الإلكترونية، تطبيقات الجوال (iOS و Android)، التسويق الرقمي، استضافة المواقع، تصميم الجرافيك، وأرشفة المواقع لمحركات البحث."
            }
        },
        {
            "@type": "Question",
            "name": "كم تستغرق مدة تصميم موقع إلكتروني؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "تعتمد المدة على حجم وتعقيد المشروع. المواقع البسيطة تستغرق من 2-4 أسابيع، بينما المشاريع الكبيرة قد تستغرق من 2-3 أشهر. نحرص على تسليم المشروع في الوقت المحدد مع الحفاظ على أعلى معايير الجودة."
            }
        },
        {
            "@type": "Question",
            "name": "هل تقدمون خدمات الدعم الفني بعد التسليم؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "نعم، نقدم دعم فني مجاني لمدة 3 أشهر بعد تسليم المشروع، يشمل إصلاح الأخطاء والتحديثات البسيطة. كما نوفر باقات صيانة سنوية للدعم المستمر."
            }
        },
        {
            "@type": "Question",
            "name": "ما هي تكلفة تصميم تطبيق جوال؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "تختلف التكلفة حسب متطلبات التطبيق وعدد المنصات (iOS/Android). نقدم عروض أسعار مخصصة بعد دراسة متطلبات المشروع. تواصل معنا للحصول على استشارة مجانية وعرض سعر."
            }
        },
        {
            "@type": "Question",
            "name": "هل المواقع التي تصممونها متوافقة مع الجوال؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "نعم، جميع مواقعنا مصممة بتقنية Responsive Design لتعمل بشكل مثالي على جميع الأجهزة: الكمبيوتر، التابلت، والهواتف الذكية."
            }
        },
        {
            "@type": "Question",
            "name": "كيف يمكنني التواصل معكم؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "يمكنك التواصل معنا عبر: الهاتف، البريد الإلكتروني، واتساب، أو من خلال نموذج الاتصال في موقعنا. فريقنا متاح للرد على استفساراتك."
            }
        },
        {
            "@type": "Question",
            "name": "هل تقدمون خدمات التسويق الرقمي؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "نعم، نقدم خدمات تسويق رقمي شاملة تشمل: إدارة حسابات التواصل الاجتماعي، إعلانات Google و Facebook، تحسين محركات البحث (SEO)، والتسويق بالمحتوى."
            }
        },
        {
            "@type": "Question",
            "name": "ما هي باقات الاستضافة المتوفرة؟",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "نوفر باقات استضافة متنوعة تناسب جميع الاحتياجات: استضافة مشتركة، VPS، وسيرفرات خاصة. جميع باقاتنا تشمل شهادة SSL مجانية ودعم فني على مدار الساعة."
            }
        }
    ]
}
</script>
@stop

@section('content')
<main class="main_site">
    <!-- Hero Section -->
    <div class="ds-hero ds-page-hero">
        <div class="container">
            <h1 class="ds-hero-title ds-text-center">الأسئلة الشائعة</h1>
            <p class="ds-hero-desc ds-text-center" style="margin: 0 auto;">إجابات على أكثر الأسئلة شيوعاً حول خدماتنا</p>
        </div>
    </div>

    <!-- FAQ Section -->
    <section class="faq-section py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    
                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            ما هي خدمات بداية لتقنية المعلومات؟
                        </h3>
                        <div class="faq-answer">
                            <p>نقدم خدمات متكاملة تشمل: تصميم وبرمجة المواقع الإلكترونية، تطبيقات الجوال (iOS و Android)، التسويق الرقمي، استضافة المواقع، تصميم الجرافيك، وأرشفة المواقع لمحركات البحث.</p>
                        </div>
                    </div>

                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            كم تستغرق مدة تصميم موقع إلكتروني؟
                        </h3>
                        <div class="faq-answer">
                            <p>تعتمد المدة على حجم وتعقيد المشروع. المواقع البسيطة تستغرق من 2-4 أسابيع، بينما المشاريع الكبيرة قد تستغرق من 2-3 أشهر. نحرص على تسليم المشروع في الوقت المحدد مع الحفاظ على أعلى معايير الجودة.</p>
                        </div>
                    </div>

                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            هل تقدمون خدمات الدعم الفني بعد التسليم؟
                        </h3>
                        <div class="faq-answer">
                            <p>نعم، نقدم دعم فني مجاني لمدة 3 أشهر بعد تسليم المشروع، يشمل إصلاح الأخطاء والتحديثات البسيطة. كما نوفر باقات صيانة سنوية للدعم المستمر.</p>
                        </div>
                    </div>

                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            ما هي تكلفة تصميم تطبيق جوال؟
                        </h3>
                        <div class="faq-answer">
                            <p>تختلف التكلفة حسب متطلبات التطبيق وعدد المنصات (iOS/Android). نقدم عروض أسعار مخصصة بعد دراسة متطلبات المشروع. <a href="{{ URL::to('/contact/us') }}">تواصل معنا</a> للحصول على استشارة مجانية وعرض سعر.</p>
                        </div>
                    </div>

                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            هل المواقع التي تصممونها متوافقة مع الجوال؟
                        </h3>
                        <div class="faq-answer">
                            <p>نعم، جميع مواقعنا مصممة بتقنية Responsive Design لتعمل بشكل مثالي على جميع الأجهزة: الكمبيوتر، التابلت، والهواتف الذكية.</p>
                        </div>
                    </div>

                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            كيف يمكنني التواصل معكم؟
                        </h3>
                        <div class="faq-answer">
                            <p>يمكنك التواصل معنا عبر:</p>
                            <ul>
                                <li>الهاتف: <a href="tel:{{ @$setting->phone }}">{{ @$setting->phone }}</a></li>
                                <li>البريد الإلكتروني: <a href="mailto:{{ @$setting->email }}">{{ @$setting->email }}</a></li>
                                <li>واتساب: <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', @$setting->whatsapp) }}">{{ @$setting->whatsapp }}</a></li>
                                <li><a href="{{ URL::to('/contact/us') }}">نموذج الاتصال</a></li>
                            </ul>
                        </div>
                    </div>

                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            هل تقدمون خدمات التسويق الرقمي؟
                        </h3>
                        <div class="faq-answer">
                            <p>نعم، نقدم خدمات تسويق رقمي شاملة تشمل: إدارة حسابات التواصل الاجتماعي، إعلانات Google و Facebook، تحسين محركات البحث (SEO)، والتسويق بالمحتوى.</p>
                        </div>
                    </div>

                    <div class="faq-item mb-4">
                        <h3 class="faq-question">
                            <i class="fas fa-question-circle text-primary"></i>
                            ما هي باقات الاستضافة المتوفرة؟
                        </h3>
                        <div class="faq-answer">
                            <p>نوفر باقات استضافة متنوعة تناسب جميع الاحتياجات: استضافة مشتركة، VPS، وسيرفرات خاصة. جميع باقاتنا تشمل شهادة SSL مجانية ودعم فني على مدار الساعة.</p>
                        </div>
                    </div>

                </div>
            </div>

            <!-- CTA Section -->
            <div class="text-center mt-5">
                <h3>لم تجد إجابة سؤالك؟</h3>
                <p>تواصل معنا وسنرد على استفسارك في أقرب وقت</p>
                <a href="{{ URL::to('/contact/us') }}" class="ds-btn ds-btn-primary ds-btn-lg">تواصل معنا</a>
            </div>
        </div>
    </section>
</main>

<style>
.faq-item {
    background: #f8f9fa;
    border-radius: 10px;
    padding: 20px;
    border-right: 4px solid #007bff;
}
.faq-question {
    font-size: 18px;
    margin-bottom: 15px;
    color: #333;
}
.faq-question i {
    margin-left: 10px;
}
.faq-answer {
    color: #666;
    line-height: 1.8;
}
.faq-answer ul {
    padding-right: 20px;
}
.page-header {
    padding: 60px 0;
}
</style>
@stop
