@extends('site.layout')
@section('metaTags')
  <title> تواصل معنا| {{@$setting->name}}    </title>
  <meta name='description' itemprop='description' content='{{@$setting->description}}' />
  <meta name='keywords' content='{{@$info->keywords}},{{@$setting->content}},{{@$setting->keywords}}' />
  <meta property='article:section' content='{{@$setting->description}}' />

  <meta property="og:description"content="{{@$setting->description}}" />
  <meta property="og:title"content="  تواصل معنا| {{@$setting->name}}   " />
  <meta property="og:url"content="{{URL::to('/contact/us')}}" />
  <meta property="og:site_name"content="{{@$setting->name}}" />
  <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

  <meta name="twitter:card"content="summary" />
  <meta name="twitter:title"content=" تواصل معنا| {{@$setting->name}} " />
  <meta name="twitter:site"content="bedayh4it.com" />
@stop
 @section('content')
   <main class="main_site">
     <div class="ds-hero ds-page-hero">
       <div class="container">
         <h1 class="ds-hero-title ds-text-center">تواصل معنا</h1>
         <p class="ds-breadcrumb">الرئيسية / تواصل معنا</p>
       </div>
     </div>
     
     <section class="ds-section">
       <div class="container">
         @if (count($errors) > 0)
           @foreach ($errors->all() as $error)
             <div class="ds-alert ds-alert-danger">{{ $error }}</div>
           @endforeach
         @endif
         @if(Session::has('success'))
           <div class="ds-alert ds-alert-success">{{Session::get('success')}}</div>
         @endif
         @if(Session::has('error'))
           <div class="ds-alert ds-alert-danger">{{Session::get('error')}}</div>
         @endif
         
         <div class="ds-contact-layout">
           <!-- Contact Info -->
           <div class="ds-contact-info">
             <h2>معلومات التواصل</h2>
             
             <div class="ds-contact-item">
               <div class="ds-contact-icon">
                 <i class="fas fa-map-marker-alt"></i>
               </div>
               <div class="ds-contact-text">
                 <h4>العنوان</h4>
                 <p>{{@$setting->address}}</p>
               </div>
             </div>
             
             <div class="ds-contact-item">
               <div class="ds-contact-icon">
                 <i class="fas fa-mobile-alt"></i>
               </div>
               <div class="ds-contact-text">
                 <h4>الهاتف</h4>
                 <a href="tel:{{@$setting->phone}}">{{@$setting->phone}}</a>
               </div>
             </div>
             
             <div class="ds-contact-item">
               <div class="ds-contact-icon">
                 <i class="far fa-envelope"></i>
               </div>
               <div class="ds-contact-text">
                 <h4>البريد الإلكتروني</h4>
                 <a href="mailto:{{@$setting->email}}">{{@$setting->email}}</a>
               </div>
             </div>
             
             <div class="ds-contact-social">
               <h4>تابعنا على</h4>
               <div class="ds-social-icons">
                 <a href="{{@$setting->fburl}}" target="_blank" class="ds-social-icon"><i class="fab fa-facebook-f"></i></a>
                 <a href="{{@$setting->twitter_url}}" target="_blank" class="ds-social-icon"><i class="fab fa-twitter"></i></a>
                 <a href="{{@$setting->instgram_url}}" target="_blank" class="ds-social-icon"><i class="fab fa-instagram"></i></a>
                 <a href="{{@$setting->linkedin_url}}" target="_blank" class="ds-social-icon"><i class="fab fa-linkedin-in"></i></a>
                 <a href="{{@$setting->youtube_url}}" target="_blank" class="ds-social-icon"><i class="fab fa-youtube"></i></a>
               </div>
             </div>
           </div>
           
           <!-- Contact Form -->
           <div class="ds-contact-form">
             <h2>أرسل لنا رسالة</h2>
             <form id="contact_form" action="{{URL::to('/get/help')}}" method="post" novalidate>
               {{ csrf_field() }}
               
               <div class="ds-form-group">
                 <select name="service_id" id="service_id" class="ds-form-input">
                   <option value="">اختر الخدمة (اختياري)</option>
                   @foreach($services as $service)
                     <option value="{{@$service->id}}">{{@$service->name}}</option>
                   @endforeach
                 </select>
               </div>
               
               <div class="ds-form-row">
                 <div class="ds-form-group">
                   <input type="text" id="title" class="ds-form-input" name="title" placeholder="عنوان الرسالة *" required>
                 </div>
                 <div class="ds-form-group">
                   <input type="text" id="name" class="ds-form-input" name="name" placeholder="الاسم بالكامل *" required>
                 </div>
               </div>
               
               <div class="ds-form-row">
                 <div class="ds-form-group">
                   <input type="email" id="email" class="ds-form-input" name="email" placeholder="البريد الإلكتروني *" required>
                 </div>
                 <div class="ds-form-group">
                   <input type="tel" id="phone" class="ds-form-input" name="phone" placeholder="رقم الهاتف *" required>
                 </div>
               </div>
               
               <div class="ds-form-group">
                 <textarea class="ds-form-input" id="message" name="message" placeholder="كيف نستطيع المساعدة؟" rows="5"></textarea>
               </div>
               
               <button type="submit" class="ds-btn ds-btn-primary ds-btn-lg ds-btn-block">
                 <i class="fas fa-paper-plane"></i> إرسال الرسالة
               </button>
             </form>
           </div>
         </div>
         
         <!-- Map -->
         <div class="ds-map-section">
           <h2 class="ds-section-title ds-text-center">موقعنا على الخريطة</h2>
           <div class="ds-map-container">
             {!! @$setting->map !!}
           </div>
         </div>
       </div>
     </section>
   </main>

<style>
/* Form Accessibility Styles */
.sr-only {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

.error-message {
    color: #dc3545;
    font-size: 12px;
    display: block;
    margin-top: -5px;
    margin-bottom: 5px;
}

.form-input.is-invalid {
    border-color: #dc3545 !important;
    background-color: #fff8f8 !important;
}

.form-input.is-valid {
    border-color: #28a745 !important;
}

.form-input:focus {
    outline: 2px solid #007bff;
    outline-offset: 2px;
    border-color: #007bff !important;
}

#contact_submit:disabled {
    opacity: 0.7;
    cursor: not-allowed;
}

#contact_submit.loading .fa-circle-notch {
    display: inline-block !important;
}

#contact_submit.loading .btn-text {
    opacity: 0.7;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var form = document.getElementById('contact_form');
    var submitBtn = document.getElementById('contact_submit');
    var feedbackDiv = document.getElementById('form-feedback');
    
    var messages = {
        title: 'يرجى إدخال عنوان الرسالة',
        name: 'يرجى إدخال الاسم بالكامل',
        email: 'يرجى إدخال بريد إلكتروني صحيح',
        phone: 'يرجى إدخال رقم هاتف صحيح'
    };
    
    function validateField(field) {
        var errorSpan = document.getElementById(field.id + '-error');
        var isValid = true;
        var message = '';
        
        if (field.required && !field.value.trim()) {
            isValid = false;
            message = messages[field.id] || 'هذا الحقل مطلوب';
        } else if (field.type === 'email' && field.value) {
            var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(field.value)) {
                isValid = false;
                message = messages.email;
            }
        } else if (field.id === 'phone' && field.value) {
            var phoneRegex = /^[0-9+\-\s]{8,}$/;
            if (!phoneRegex.test(field.value)) {
                isValid = false;
                message = messages.phone;
            }
        }
        
        if (errorSpan) errorSpan.textContent = message;
        field.classList.toggle('is-invalid', !isValid);
        field.classList.toggle('is-valid', isValid && field.value.trim());
        field.setAttribute('aria-invalid', !isValid);
        return isValid;
    }
    
    var requiredFields = form.querySelectorAll('[required]');
    requiredFields.forEach(function(field) {
        field.addEventListener('blur', function() { validateField(this); });
        field.addEventListener('input', function() {
            if (this.classList.contains('is-invalid')) validateField(this);
        });
    });
    
    form.addEventListener('submit', function(e) {
        var isFormValid = true;
        requiredFields.forEach(function(field) {
            if (!validateField(field)) isFormValid = false;
        });
        
        if (!isFormValid) {
            e.preventDefault();
            if (feedbackDiv) feedbackDiv.textContent = 'يرجى تصحيح الأخطاء في النموذج';
            var firstInvalid = form.querySelector('.is-invalid');
            if (firstInvalid) firstInvalid.focus();
            return false;
        }
        
        submitBtn.classList.add('loading');
        submitBtn.disabled = true;
        if (feedbackDiv) feedbackDiv.textContent = 'جاري إرسال الرسالة...';
    });
});
</script>

 @stop