@extends('site.layout')
@section('metaTags')
<title>المدونه | {{@$setting->name}} </title>
<meta name='description' itemprop='description' content='{{ @$info->content_ar}}' />
<meta name='keywords' content='{{@$setting->meta_tags}},{{@$info->content_ar}},{{@$info->story}},{{@$info->mission}},{{@$info->vision}}' />
<meta property='article:section' content='{!! @$setting->description !!}' />

<meta property="og:description"content="{{ @$info->content_ar }}" />
<meta property="og:title"content=" المدونه | {{@$setting->name}} " />
<meta property="og:url"content="{{URL::to('/blogs')}}" />
<meta property="og:site_name"content="{{@$setting->name}}" />
<meta property="og:image" content="{{URL::to('').@$info->file}}">

<meta name="twitter:card"content="summary" />
<meta name="twitter:title"content=" المدونه | {{@$setting->name}}" />
<meta name="twitter:site"content="bedayh4it.com" />
@stop
 @section('content')
  <main class="main_site">
      <div class="ds-hero ds-page-hero">
        <div class="container">
          <h1 class="ds-hero-title ds-text-center">المدونة</h1>
          <p class="ds-breadcrumb">الرئيسية / المدونة</p>
        </div>
      </div>
      <section class="ds-section">
        <div class="container">
          <div class="ds-grid ds-grid-3">
            @foreach($blogs as $blog)
            <a href="{{URL::to('/')}}/blog/{{@str_replace(' ','_',$blog->title)}}" class="ds-card ds-blog-card">
              <div class="ds-blog-img">
                <img src="{{ URL::to('') }}{{$blog->image}}" alt="{{$blog->title}}" loading="lazy">
              </div>
              <div class="ds-blog-content">
                <h3>{{$blog->title}}</h3>
                <p>اقرأ المزيد عن هذا الموضوع</p>
              </div>
            </a>
            @endforeach
          </div>
        
          <nav aria-label="Page navigation example" class="margin_top">
            <ul class="pagination justify-content-center">
              <li class="page-item">
                <a class="page-link bg_blue_grad text-white" href="#" aria-label="Previous">
                  <span aria-hidden="true">&laquo;</span>
                  <span class="sr-only">Previous</span>
                </a>
              </li>
              <li class="page-item"><a class="page-link" href="#">1</a></li>
              <li class="page-item"><a class="page-link" href="#">2</a></li>
              <li class="page-item"><a class="page-link" href="#">3</a></li>
              <li class="page-item">
                <a class="page-link bg_blue_grad text-white" href="#" aria-label="Next">
                  <span aria-hidden="true">&raquo;</span>
                  <span class="sr-only">Next</span>
                </a>
              </li>
            </ul>
          </nav>
        </div>
      </section>
    </main>
@stop