@extends('site.layout')
@section('metaTags')
<title>من نحن  | {{@$setting->name}} </title>
<meta name='description' itemprop='description' content='{!! @$info->content_ar!!}' />
<meta name='keywords' content='{{@$setting->meta_tags}},{{@$info->content_ar}},{{@$info->story}},{{@$info->mission}},{{@$info->vision}}' />
<meta property='article:section' content='{!! @$setting->description !!}' />

<meta property="og:description"content="{{ @$info->content_ar }}" />
<meta property="og:title"content=" من نحن  | {{@$setting->name}} " />
<meta property="og:url"content="{{URL::to('/about_us')}}" />
<meta property="og:site_name"content="{{@$setting->name}}" />
<meta property="og:image" content="{{URL::to('/').@$info->file}}">

<meta name="twitter:card"content="summary" />
<meta name="twitter:title"content=" من نحن  | {{@$setting->name}}" />
<meta name="twitter:site"content="bedayh4it.com" />
@stop
 @section('content')
<main class="main_site">
  <!-- Hero Section -->
  <div class="ds-hero ds-page-hero">
    <div class="container">
      <h1 class="ds-hero-title ds-text-center">كل ما تريد معرفته عنا</h1>
      <p class="ds-breadcrumb">الرئيسية / من نحن</p>
    </div>
  </div>

  <!-- Features Section -->
  <section class="ds-section">
    <div class="container">
      <h2 class="ds-section-title ds-text-center">لماذا تختارنا؟</h2>
      <p class="ds-section-desc ds-text-center">نقدم لك أفضل الحلول التقنية بأعلى معايير الجودة</p>
      
      <div class="ds-features-grid">
        <div class="ds-feature-card">
          <div class="ds-feature-icon">
            <i class="fas fa-pen-nib"></i>
          </div>
          <h3>تصميمات متميزة</h3>
          <p>تصميمات عصرية وجذابة تناسب هوية علامتك التجارية</p>
        </div>
        
        <div class="ds-feature-card">
          <div class="ds-feature-icon">
            <i class="fas fa-clock"></i>
          </div>
          <h3>وقت أقل</h3>
          <p>نلتزم بالمواعيد ونسلم المشاريع في الوقت المحدد</p>
        </div>
        
        <div class="ds-feature-card">
          <div class="ds-feature-icon">
            <i class="fas fa-percent"></i>
          </div>
          <h3>عروض كبيرة</h3>
          <p>أسعار تنافسية وعروض مميزة على جميع خدماتنا</p>
        </div>
        
        <div class="ds-feature-card">
          <div class="ds-feature-icon">
            <i class="fas fa-users-cog"></i>
          </div>
          <h3>فريق عمل متميز</h3>
          <p>فريق من المحترفين ذوي الخبرة في مجالاتهم</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Tabs Section -->
  <section class="ds-tabs-section">
    <div class="container">
      <div class="ds-tabs-nav">
        <button class="ds-tab-btn active" data-tab="who_we_are">من نحن</button>
        <button class="ds-tab-btn" data-tab="story">رسالتنا</button>
        <button class="ds-tab-btn" data-tab="mission">أهدافنا</button>
        <button class="ds-tab-btn" data-tab="vision">رؤيتنا</button>
      </div>
      
      <div class="ds-tabs-content">
        <div class="ds-tab-content active" id="tab-who_we_are">
          <div class="ds-tab-panel">
            <div>{!! @$info->content_ar !!}</div>
          </div>
        </div>
        
        <div class="ds-tab-content" id="tab-story">
          <div class="ds-tab-panel">
            <div>{!! @$info->story !!}</div>
          </div>
        </div>
        
        <div class="ds-tab-content" id="tab-mission">
          <div class="ds-tab-panel">
            <div>{!! @$info->mission !!}</div>
          </div>
        </div>
        
        <div class="ds-tab-content" id="tab-vision">
          <div class="ds-tab-panel">
            <div>{!! @$info->vision !!}</div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Stats Section -->
  <section class="ds-stats-section">
    <div class="container">
      <div class="ds-stats-grid">
        <div class="ds-stat-item">
          <div class="ds-stat-icon"><i class="fas fa-calendar-alt"></i></div>
          <span class="ds-stat-number" data-count="10">0</span>
          <span class="ds-stat-label">سنوات الخبرة</span>
        </div>
        
        <div class="ds-stat-item">
          <span class="ds-stat-icon"><i class="fas fa-project-diagram"></i></span>
          <span class="ds-stat-number" data-count="500">0</span>
          <span class="ds-stat-label">مشروع منجز</span>
        </div>
        
        <div class="ds-stat-item">
          <span class="ds-stat-icon"><i class="fas fa-smile"></i></span>
          <span class="ds-stat-number" data-count="350">0</span>
          <span class="ds-stat-label">عميل سعيد</span>
        </div>
        
        <div class="ds-stat-item">
          <span class="ds-stat-icon"><i class="fas fa-users"></i></span>
          <span class="ds-stat-number" data-count="25">0</span>
          <span class="ds-stat-label">عضو في الفريق</span>
        </div>
      </div>
    </div>
  </section>

  <!-- Help Section -->
  <section class="ds-help-section">
    <div class="container">
      <div class="ds-help-content">
        <div class="ds-help-image">
          <img src="{{ URL::to('/') }}/assets/site/img/screen.png" alt="نحن نساعدك" loading="lazy">
        </div>
        <div class="ds-help-text">
          <h2>نحن نساعدك في العثور على ما تريد</h2>
          <p>{!! @$info->we_help !!}</p>
          <ul class="ds-help-list">
            <li>حلول تقنية متكاملة ومخصصة</li>
            <li>دعم فني على مدار الساعة</li>
            <li>أسعار تنافسية وشفافة</li>
            <li>التزام بالجودة والمواعيد</li>
          </ul>
          <a href="{{URL::to('/contact/us')}}" class="ds-btn ds-btn-primary ds-btn-lg">تواصل معنا</a>
        </div>
      </div>
    </div>
  </section>

  <!-- CTA Section -->
  <section class="ds-cta-section">
    <div class="container">
      <h2>هل أنت جاهز لبدء مشروعك؟</h2>
      <p>تواصل معنا اليوم واحصل على استشارة مجانية</p>
      <a href="{{URL::to('/contact/us')}}" class="ds-btn ds-btn-lg">احصل على عرض سعر</a>
    </div>
  </section>
</main>
@stop