{{-- Video Embed Component --}}
{{-- Usage: @include('components.video-embed', ['url' => 'https://youtube.com/watch?v=xxx', 'title' => 'Video Title']) --}}

@php
    $videoId = null;
    $platform = 'unknown';
    
    // YouTube
    if (preg_match('/(?:youtube\.com\/(?:watch\?v=|embed\/)|youtu\.be\/)([a-zA-Z0-9_-]{11})/', $url ?? '', $matches)) {
        $videoId = $matches[1];
        $platform = 'youtube';
    }
    // Vimeo
    elseif (preg_match('/vimeo\.com\/(?:video\/)?(\d+)/', $url ?? '', $matches)) {
        $videoId = $matches[1];
        $platform = 'vimeo';
    }
@endphp

@if($videoId)
<div class="video-embed-container" style="position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; max-width: 100%; border-radius: 8px;">
    @if($platform === 'youtube')
        <iframe 
            src="https://www.youtube-nocookie.com/embed/{{ $videoId }}?rel=0" 
            title="{{ $title ?? 'فيديو' }}"
            style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: 0;"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
            allowfullscreen
            loading="lazy">
        </iframe>
    @elseif($platform === 'vimeo')
        <iframe 
            src="https://player.vimeo.com/video/{{ $videoId }}?dnt=1" 
            title="{{ $title ?? 'فيديو' }}"
            style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: 0;"
            allow="autoplay; fullscreen; picture-in-picture" 
            allowfullscreen
            loading="lazy">
        </iframe>
    @endif
</div>
@else
<p class="text-muted">رابط الفيديو غير صالح</p>
@endif
