{{-- Modal Component --}}
{{-- Usage: @include('components.modal', ['id' => 'myModal', 'title' => 'Title', 'content' => 'Content']) --}}

<div class="modal-overlay" id="{{ $id ?? 'modal' }}" role="dialog" aria-modal="true" aria-labelledby="{{ $id ?? 'modal' }}-title" style="display: none;">
    <div class="modal-container">
        <div class="modal-header">
            <h3 id="{{ $id ?? 'modal' }}-title">{{ $title ?? '' }}</h3>
            <button type="button" class="modal-close" onclick="closeModal('{{ $id ?? 'modal' }}')" aria-label="إغلاق">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            {!! $content ?? $slot ?? '' !!}
        </div>
        @if(isset($footer))
        <div class="modal-footer">
            {!! $footer !!}
        </div>
        @endif
    </div>
</div>

<style>
.modal-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); z-index: 9999; display: flex; align-items: center; justify-content: center; opacity: 0; transition: opacity 0.3s; }
.modal-overlay.active { opacity: 1; }
.modal-container { background: #fff; border-radius: 12px; max-width: 600px; width: 90%; max-height: 90vh; overflow: hidden; transform: scale(0.9); transition: transform 0.3s; }
.modal-overlay.active .modal-container { transform: scale(1); }
.modal-header { display: flex; justify-content: space-between; align-items: center; padding: 15px 20px; border-bottom: 1px solid #eee; }
.modal-header h3 { margin: 0; font-size: 18px; }
.modal-close { background: none; border: none; font-size: 20px; cursor: pointer; padding: 5px; color: #666; }
.modal-close:hover { color: #333; }
.modal-close:focus { outline: 2px solid #007bff; }
.modal-body { padding: 20px; overflow-y: auto; max-height: 60vh; }
.modal-footer { padding: 15px 20px; border-top: 1px solid #eee; text-align: left; }
</style>

<script>
function openModal(id) {
    var modal = document.getElementById(id);
    if (modal) { modal.style.display = 'flex'; setTimeout(function() { modal.classList.add('active'); }, 10); document.body.style.overflow = 'hidden'; }
}
function closeModal(id) {
    var modal = document.getElementById(id);
    if (modal) { modal.classList.remove('active'); setTimeout(function() { modal.style.display = 'none'; }, 300); document.body.style.overflow = ''; }
}
document.addEventListener('keydown', function(e) { if (e.key === 'Escape') { document.querySelectorAll('.modal-overlay.active').forEach(function(m) { closeModal(m.id); }); } });
</script>
