{{-- Language Switcher Component --}}
{{-- Usage: @include('components.language-switcher') --}}

<div class="language-switcher" role="navigation" aria-label="اختيار اللغة">
    <button class="lang-toggle" onclick="toggleLangMenu()" aria-expanded="false" aria-haspopup="true">
        <i class="fas fa-globe"></i>
        <span class="current-lang">{{ app()->getLocale() == 'ar' ? 'العربية' : 'English' }}</span>
        <i class="fas fa-chevron-down"></i>
    </button>
    <ul class="lang-menu" role="menu">
        <li role="menuitem">
            <a href="{{ url('lang/ar') }}" class="{{ app()->getLocale() == 'ar' ? 'active' : '' }}">
                <span>العربية</span>
                @if(app()->getLocale() == 'ar')<i class="fas fa-check"></i>@endif
            </a>
        </li>
        <li role="menuitem">
            <a href="{{ url('lang/en') }}" class="{{ app()->getLocale() == 'en' ? 'active' : '' }}">
                <span>English</span>
                @if(app()->getLocale() == 'en')<i class="fas fa-check"></i>@endif
            </a>
        </li>
    </ul>
</div>

<style>
.language-switcher { position: relative; display: inline-block; }
.lang-toggle { background: transparent; border: 1px solid #ddd; border-radius: 6px; padding: 8px 12px; cursor: pointer; display: flex; align-items: center; gap: 8px; font-size: 14px; transition: all 0.3s; }
.lang-toggle:hover { background: #f5f5f5; border-color: #ccc; }
.lang-toggle:focus { outline: 2px solid #007bff; }
.lang-menu { position: absolute; top: 100%; right: 0; background: #fff; border: 1px solid #ddd; border-radius: 6px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); list-style: none; margin: 5px 0 0; padding: 5px 0; min-width: 140px; display: none; z-index: 1000; }
.lang-menu.active { display: block; }
.lang-menu li a { display: flex; justify-content: space-between; align-items: center; padding: 10px 15px; color: #333; text-decoration: none; transition: background 0.2s; }
.lang-menu li a:hover { background: #f5f5f5; }
.lang-menu li a.active { background: #e8f4ff; color: #007bff; }
</style>

<script>
function toggleLangMenu() {
    var menu = document.querySelector('.lang-menu');
    var btn = document.querySelector('.lang-toggle');
    var isActive = menu.classList.toggle('active');
    btn.setAttribute('aria-expanded', isActive);
}
document.addEventListener('click', function(e) {
    if (!e.target.closest('.language-switcher')) {
        var menu = document.querySelector('.lang-menu');
        var btn = document.querySelector('.lang-toggle');
        if (menu) { menu.classList.remove('active'); btn.setAttribute('aria-expanded', 'false'); }
    }
});
</script>
