@props(['items' => []])

@if(count($items) > 0)
<nav aria-label="breadcrumb" class="breadcrumb-nav">
    <ol class="breadcrumb" itemscope itemtype="https://schema.org/BreadcrumbList">
        <li class="breadcrumb-item" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
            <a href="{{ URL::to('/') }}" itemprop="item">
                <span itemprop="name">الرئيسية</span>
            </a>
            <meta itemprop="position" content="1" />
        </li>
        @foreach($items as $index => $item)
        <li class="breadcrumb-item {{ $loop->last ? 'active' : '' }}" 
            itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem"
            @if($loop->last) aria-current="page" @endif>
            @if($loop->last)
                <span itemprop="name">{{ $item['title'] }}</span>
            @else
                <a href="{{ $item['url'] }}" itemprop="item">
                    <span itemprop="name">{{ $item['title'] }}</span>
                </a>
            @endif
            <meta itemprop="position" content="{{ $index + 2 }}" />
        </li>
        @endforeach
    </ol>
</nav>

<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "BreadcrumbList",
    "itemListElement": [
        {
            "@type": "ListItem",
            "position": 1,
            "name": "الرئيسية",
            "item": "{{ URL::to('/') }}"
        }
        @foreach($items as $index => $item)
        ,{
            "@type": "ListItem",
            "position": {{ $index + 2 }},
            "name": "{{ $item['title'] }}",
            "item": "{{ $item['url'] ?? URL::current() }}"
        }
        @endforeach
    ]
}
</script>

<style>
.breadcrumb-nav {
    padding: 15px 0;
    background: transparent;
}
.breadcrumb {
    background: transparent;
    padding: 0;
    margin: 0;
}
.breadcrumb-item + .breadcrumb-item::before {
    content: ">";
    padding: 0 8px;
}
.breadcrumb-item a {
    color: #007bff;
    text-decoration: none;
}
.breadcrumb-item.active {
    color: #6c757d;
}
</style>
@endif
