{{-- Accordion Component --}}
{{-- Usage: @include('components.accordion', ['items' => [['title' => 'Q1', 'content' => 'A1'], ...]]) --}}

<div class="accordion-container" id="accordion-{{ $id ?? 'default' }}">
    @foreach($items ?? [] as $index => $item)
    <div class="accordion-item">
        <button class="accordion-header" 
                type="button"
                aria-expanded="{{ $index === 0 ? 'true' : 'false' }}"
                aria-controls="accordion-content-{{ $id ?? 'default' }}-{{ $index }}"
                onclick="toggleAccordion(this)">
            <span>{{ $item['title'] }}</span>
            <i class="fas fa-chevron-down accordion-icon"></i>
        </button>
        <div class="accordion-content {{ $index === 0 ? 'active' : '' }}" 
             id="accordion-content-{{ $id ?? 'default' }}-{{ $index }}">
            <div class="accordion-body">
                {!! $item['content'] !!}
            </div>
        </div>
    </div>
    @endforeach
</div>

<style>
.accordion-item { border: 1px solid #e0e0e0; border-radius: 8px; margin-bottom: 10px; overflow: hidden; }
.accordion-header { width: 100%; padding: 15px 20px; background: #f8f9fa; border: none; cursor: pointer; display: flex; justify-content: space-between; align-items: center; font-size: 16px; font-weight: 600; text-align: right; transition: background 0.3s; }
.accordion-header:hover { background: #e9ecef; }
.accordion-header:focus { outline: 2px solid #007bff; outline-offset: -2px; }
.accordion-icon { transition: transform 0.3s; }
.accordion-header[aria-expanded="true"] .accordion-icon { transform: rotate(180deg); }
.accordion-content { max-height: 0; overflow: hidden; transition: max-height 0.3s ease-out; }
.accordion-content.active { max-height: 500px; }
.accordion-body { padding: 15px 20px; background: #fff; }
</style>

<script>
function toggleAccordion(btn) {
    var expanded = btn.getAttribute('aria-expanded') === 'true';
    btn.setAttribute('aria-expanded', !expanded);
    var content = btn.nextElementSibling;
    content.classList.toggle('active');
}
</script>
