@extends('admin.layout')
@section('styleCode')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css"/>
@stop
@section('content')
 <!-- BEGIN PAGE HEADER-->
  <!-- BEGIN PAGE HEADER-->
  <h3 class="page-title">
أراء العملاء<small>قائمة أراء العملاء</small>
  </h3>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <i class="fa fa-home"></i>
        <a href="{{URL::to('/admin/home')}}">الرئيسيه</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="{{URL::to('/admin')}}/testmonials">أراء العملاء</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="#">قائمة اراء العملاء</a>
      </li>
    </ul>
  </div>
  <!-- END PAGE HEADER-->

   <div class="portlet box purple ">
    <div class="portlet-title">
      <div class="caption">
        <i class="fa fa-gift"></i>تحديث بيانات
      </div>
      <div class="tools">
        <a href="" class="collapse">
        </a>

        <a href="" class="reload">
        </a>
        <a href="" class="remove">
        </a>
      </div>
    </div>
    <div class="clearfix visible-xs-block"></div>

    @if(Session::has('success'))
    <div class="alert alert-success">{{Session::get('success')}}</div>
    @endif
    <div class="portlet-body form col-md-12">
      <!-- END EXAMPLE TABLE PORTLET-->
      <table id="example" class="table table-striped table-bordered table-hover" cellspacing="0" width="100%">
          <thead>
              <tr>
                  <th>#</th>
                  <th>اسم الخدمه</th>
                  <th>تعليق</th>
                  <th>تعديل</th>
                  <th>حذف</th>
              </tr>
          </thead>
          
          <tbody>
          @foreach($testmonials as $testmonial)
              <tr>
                  <td>
                  {{@$testmonial->id}}
                  </td>
                  <td>
                  {{@$testmonial->name}}
                  </td>
                  <td>
                    {{@substr($testmonial->comment,0,50).'...'}}
                  </td>
                  <td>
                     <center><a href="{{URL::to('/')}}/admin/testmonials/{{@$testmonial->id}}/edit"><li class="fa fa-pencil btn btn-warning"></li></a></center>
                  </td>
                  <td>
                     @include('admin.testmonials.model_delete')
                  </td>
              </tr>
          @endforeach
          </tbody>
      </table>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@stop
@section('jsCode')
<script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function() {
    $('#example').DataTable();
} );
</script>
@stop