@extends('admin.layout')
@section('styleCode')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css"/>
@stop
@section('content')
<!-- BEGIN PAGE HEADER-->
<h3 class="page-title">
    المعرض <small>قائمة المعرض</small>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="{{URL::to('/admin/home')}}">الرئيسيه</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="{{URL::to('/admin/slider')}}">المعرض</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="{{URL::to('/admin/categories/create')}}">قائمة المعرض</a>
        </li>
    </ul>
</div>
<!-- END PAGE HEADER-->
  @if(Session::has('success'))
  <div class="alert alert-success">{{Session::get('success')}}</div>
  @endif
    <!-- END EXAMPLE TABLE PORTLET-->
    <table id="example" class="table table-striped table-bordered table-hover" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>#</th>
                <th>العرض</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tfoot>
         <tr>
         <th>#</th>
         <th>العرض</th>
         <th>تعديل</th>
         <th>حذف</th>
          </tr>
        </tfoot>
        <tbody>
        @foreach($sliders as $slider)
            <tr>
                <td>
                  <span>{{@$slider->id}}</span>
               
                </td>
                <td>
                  <img src="{{ URL::to('/') }}{{ $slider->image }}" class="img-responsive img-rounded" style="width:93px;display: inline-block;">
                </td>
                <td>
                   <center><a href="{{URL::to('/')}}/admin/slider/{{@$slider->id}}/edit"><li class="fa fa-pencil btn btn-warning"></li></a></center>
                </td>
                <td>
                    <center><a href="{{URL::to('/')}}/admin/slider/{{@$slider->id}}/delete"><li class="fa fa-trash-o btn btn-danger"></li></a></center>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <!-- END EXAMPLE TABLE PORTLET-->
@stop
@section('jsCode')
<script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function() {
    $('#example').DataTable();
} );
</script>
@stop