@extends('admin.layout')
@section('content')
     <!-- BEGIN PAGE HEADER-->
  <h2 class="page-title">
معرض الخدمات <small>اضافه جديد</small>
  </h2>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <i class="fa fa-home"></i>
        <a href="{{URL::to('/admin/home')}}">الرئيسيه</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="{{URL::to('/admin')}}/services">الخدمات</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="#">اضافه خدمه جديده</a>
      </li>
    </ul>
  </div>
  <!-- END PAGE HEADER-->
  <!-- BEGIN SAMPLE FORM PORTLET-->
  <div class="portlet box purple ">
    <div class="portlet-title">
      <div class="caption">
        <i class="fa fa-gift"></i> اضافه خدمه جديده
      </div>
      <div class="tools">
        <a href="" class="collapse">
        </a>

        <a href="" class="reload">
        </a>
        <a href="" class="remove">
        </a>
      </div>
    </div>
    <div class="portlet-body form col-md-12">
      <form action="{{ url('admin/services') }}" method="POST" class="form-horizontal" role="form" enctype="multipart/form-data">@csrf
      @if (count($errors) > 0)
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
      @endif
      @if(Session::has('success'))
      <div class="alert alert-success">{{Session::get('success')}}</div>
      @endif
        <div class="form-body">

           <div class="form-group">
            <label class="col-md-2 control-label">اسم الخدمه</label>
            <div class="col-md-9">
              <input type="text" name="name" class="form-control input-lg"  placeholder="إسم الخدمه.." value="{{ Request::old('name') }}">
            </div>
          </div>

          <!-- SEO Settings -->
          <div class="form-group">
            <label class="col-md-2 control-label">عنوان SEO</label>
            <div class="col-md-9">
              <input type="text" name="meta_title" class="form-control" maxlength="70" placeholder="عنوان الصفحة لمحركات البحث (70 حرف كحد أقصى)" value="{{ Request::old('meta_title') }}">
              <small class="help-block">اتركه فارغاً لاستخدام اسم الخدمة</small>
            </div>
          </div>

          <div class="form-group">
            <label class="col-md-2 control-label">وصف SEO</label>
            <div class="col-md-9">
              <textarea name="meta_description" class="form-control" maxlength="160" rows="2" placeholder="وصف الصفحة لمحركات البحث (160 حرف كحد أقصى)">{{ Request::old('meta_description') }}</textarea>
              <small class="help-block">اتركه فارغاً لاستخدام تعريف الخدمة</small>
            </div>
          </div>
          <!-- End SEO Settings -->

        <div class="form-group">
            <label class="col-md-2 control-label">الكلمات الدلاليه</label>
            <div class="col-md-9">
                <input type="text"
                       name="keywords"
                       class="form-control input-lg"
                       placeholder="الكلمات الدلاليه.."
                       value="{{ Request::old('keywords') }}">
            </div>
        </div>

        <div class="form-group">
            <label class="col-md-2 control-label">تعريف الخدمة </label>
            <div class="col-md-9">
                <textarea  class="form-control"  name="details">{{ Request::old('details') }}</textarea>
            </div>
        </div>

        <div class="form-group">
            <label class="col-md-2 control-label">تفاصيل الخدمه</label>
            <div class="col-md-9">
                <textarea  class="form-control" id="editor1" name="content">{{ Request::old('content') }}</textarea>
            </div>
        </div>

        <div class="form-group">
            <label class="col-md-2 control-label">مكان العرض</label>
             <div class="col-md-3">
              اساسى
               <input name="default" type="checkbox" value="1" checked>

            </div>

            <div class="col-md-3">
              فى القائمة
               <input name="menu" type="checkbox" value="1">

            </div>

           

        </div>  



      

            <div class="form-group">
            <label class="col-md-2 control-label">الصوره</label>
            <div class="col-md-9">
              <!-- The fileupload-buttonbar contains buttons to add/delete files and start/cancel the upload -->
                <div class="row fileupload-buttonbar">
                    <div class="col-lg-7">
                        <!-- The fileinput-button span is used to style the file input field as button -->
                        <span class="btn green fileinput-button">
                        <i class="fa fa-plus"></i>
                        <span>
                        تصفح جهازك... </span>
                        <input type="file" name="icon"  >
                        </span>
                    </div>
                    <!-- The global progress information -->
                </div>
                <!-- The table listing the files available for upload/download -->
            </div>
          </div>
          <div class="form-actions right1">
            <button type="submit" class="btn green">إضافه</button>
          </div>
        </form>
    </div>
    
  </div>
  <!-- END SAMPLE FORM PORTLET-->
@stop