@extends('admin.layout')
@section('content')
 <!-- BEGIN PAGE HEADER-->
  <h3 class="page-title">
الأعمال <small>تعديل البيانات</small>
  </h3>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <i class="fa fa-home"></i>
        <a href="{{URL::to('/admin/home')}}">الرئيسيه</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="{{URL::to('/admin')}}/portfolio">معرض الأعمال</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="#">تعديل بيانات</a>
      </li>
    </ul>
  </div>
  <!-- END PAGE HEADER-->
  <!-- BEGIN SAMPLE FORM PORTLET-->
  <div class="portlet box purple ">
    <div class="portlet-title">
      <div class="caption">
        <i class="fa fa-gift"></i>تعديل بيانات
      </div>
      <div class="tools">
        <a href="" class="collapse">
        </a>

        <a href="" class="reload">
        </a>
        <a href="" class="remove">
        </a>
      </div>
    </div>
    <div class="portlet-body form col-md-12">
    <div class="form col-md-9">
    <form action="{{ url('admin/portfolio/'.$info->id) }}" method="POST" class="form-horizontal" role="form" enctype="multipart/form-data">
      @csrf
      @method('PUT')
      @if (count($errors) > 0)
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
      @endif
      @if(Session::has('success'))
      <div class="alert alert-success">{{Session::get('success')}}</div>
      @endif
        <div class="form-body">
          
            <div class="form-group">
                <label class="col-md-3 control-label">فئه / خدمه</label>
                <div class="col-md-9">
                  <select name="service_id" class="form-control input-lg">
                    @foreach ($services as $service)
                    <option value="{{ @$service->id }}" @if($service->id == $info->service_id) selected @endif>{{ @$service->name }}</option>                    
                    @endforeach
                  </select>
                </div>
              </div>
    
              <div class="form-group">
                <label class="col-md-3 control-label">اسم العمل</label>
                <div class="col-md-9">
                  <input type="text" name="name" class="form-control input-lg"  placeholder="اسم العمل.." value="{{ @$info->name }}">
                </div>
              </div>

              <!-- SEO Settings -->
              <div class="form-group">
                <label class="col-md-3 control-label">عنوان SEO</label>
                <div class="col-md-9">
                  <input type="text" name="meta_title" class="form-control" maxlength="70" placeholder="عنوان الصفحة لمحركات البحث (70 حرف كحد أقصى)" value="{{ @$info->meta_title }}">
                  <small class="help-block">اتركه فارغاً لاستخدام اسم العمل</small>
                </div>
              </div>

              <div class="form-group">
                <label class="col-md-3 control-label">وصف SEO</label>
                <div class="col-md-9">
                  <textarea name="meta_description" class="form-control" maxlength="160" rows="2" placeholder="وصف الصفحة لمحركات البحث (160 حرف كحد أقصى)">{{ @$info->meta_description }}</textarea>
                </div>
              </div>
              <!-- End SEO Settings -->
             
              <div class="form-group">
                <label class="col-md-3 control-label">نبذه عن العمل</label>
                <div class="col-md-9">
                    <textarea name="content" id="editor1" class="form-control input-lg"  placeholder="نبذه عن العمل.." >{{ @$info->content }}</textarea>
                </div>
              </div>
             
              <div class="form-group">
                  <label class="col-md-3 control-label">الكلمات الدلاليه</label>
                  <div class="col-md-9">
                    <input type="text" name="keywords" class="form-control input-lg"  placeholder="الكلمات الدلاليه.." value="{{ @$info->keywords }}">
                  </div>
              </div>
              
          <div class="form-group">
              <label class="col-md-3 control-label">رابط  android </label>
              <div class="col-md-9">
                <input type="text" name="android" class="form-control input-lg"  placeholder="ابط  android.." value="{{ @$info->android }}">
              </div>
          </div>

          <div class="form-group">
              <label class="col-md-3 control-label">رابط  ios</label>
              <div class="col-md-9">
                <input type="text" name="ios" class="form-control input-lg"  placeholder="ابط  ios.." value="{{ @$info->ios }}">
              </div>
          </div>

          <div class="form-group">
              <label class="col-md-3 control-label">رابط  website</label>
              <div class="col-md-9">
                <input type="text" name="website" class="form-control input-lg"  placeholder="ابط  website .." value="{{ @$info->website }}">
              </div>
          </div>

           <div class="form-group">
            <label class="col-md-3 control-label">الصوره</label>
            <div class="col-md-9">
              <!-- The fileupload-buttonbar contains buttons to add/delete files and start/cancel the upload -->
                <div class="row fileupload-buttonbar">
                    <div class="col-lg-7">
                        <!-- The fileinput-button span is used to style the file input field as button -->
                        <span class="btn green fileinput-button">
                        <i class="fa fa-plus"></i>
                        <span>
                        تصفح جهازك... </span>
                        <input type="file" name="image[]" multiple >
                        </span>
                    </div>
                    <!-- The global progress information -->
                </div>
                <!-- The table listing the files available for upload/download -->
            </div>
          </div>
          <div class="form-actions right1">
            <button type="submit" class="btn green">تحديث</button>
          </div>
        </form>
    </div>
    </div>
    <div class="form col-md-3">
    <!--<img src="{{ URL::to('/') }}/{{ @$info->images->first()->image }}" class="img-responsive img-rounded" >-->
    <!--start slid-->
    <div id="myCarousel" class="carousel slide" data-ride="carousel">
  <!-- Indicators -->
  <ol class="carousel-indicators">
           @foreach($info->images as $key=> $image)
    <li data-target="#myCarousel" data-slide-to="{{@$key}}" class="{{ $loop->first ? 'active': ''}}"></li>
        @endforeach
  </ol>

  <!-- Wrapper for slides -->
  <div class="carousel-inner">
     @foreach($info->images as $image)
    <div class="{{ $loop->first ? 'item active': 'item'}}">
      <img src="{{ URL::to('/') }}{{@$image->image}}" class="img-responsive img-rounded">
      <a class="left carousel-control" href="{{URL::to('/admin/gallery_delete/').'/'.@$image->id}}" >
     <li class="fa fa-trash-o btn btn-danger"></li>
  </a>
    </div>
    @endforeach

  </div>

  <!-- Left and right controls -->
 
</div>
    <!--end slide-->
    </div>
     
  </div>
  <!-- END SAMPLE FORM PORTLET-->
@stop