@extends('admin.layout')
@section('styleCode')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css"/>
@stop
@section('content')
 <!-- BEGIN PAGE HEADER-->
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <i class="fa fa-home"></i>
        <a href="{{URL::to('/admin/home')}}">الرئيسيه</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="{{URL::to('/admin')}}/hosts">  باقات الاستضافة</a>
      </li>
     
    </ul>
  </div>
  <!-- END PAGE HEADER-->
@if(Session::has('success'))
  <div class="alert alert-success">{{Session::get('success')}}</div>
  @endif
    <!-- END EXAMPLE TABLE PORTLET-->
    <table id="example" class="table table-striped table-bordered table-hover" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>#</th>
                <th>اسم الباقة</th>
                <th>شعار الخدمه</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
        </thead>
        
        <tbody>
        @foreach($hosts as $host)
            <tr>
                <td>
                {{@$host->id}}
                </td>
                <td>
                {{@$host->name}}
                </td>
                <td>
                {{@$host->price}}

                </td>
                <td>
                   <center><a href="{{URL::to('/')}}/admin/hosts/{{@$host->id}}/edit"><li class="fa fa-pencil btn btn-warning"></li></a></center>
                </td>
                <td>
                    {{-- <center><a href="{{URL::to('/')}}/admin/services/{{@$service->id}}/delete"><li class="fa fa-trash-o btn btn-danger"></li></a></center> --}}

                       <center><a  data-toggle="modal" data-target="#delete{{ @$host->id }}"><li class="fa fa-trash-o btn btn-danger"></li></a></center>

                       {{-- start delete --}}
                        <div id="delete{{ @$host->id }}" class="modal fade" role="dialog">
                         <form action="{{ url('admin/hosts/'.$host->id) }}" method="POST">
                          @csrf
                          @method('DELETE')
                          <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h4 class="modal-title">هل انت متأكد من إتمام عملية الحذف؟</h4>
                              </div>
                              <div class="modal-body">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">لا</button>

                                <button type="submit" class="btn btn-danger">نعم</button>
                              </div>
                            </div>
                          </div>
                          </form>
                        </div>
                       {{-- start delete --}}
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <!-- END EXAMPLE TABLE PORTLET-->
@stop
@section('jsCode')
<script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function() {
    $('#example').DataTable();
} );
</script>
@stop