@extends('admin.layout')

@section('content')
    <div class="row">
        <!-- Stats Cards -->
        <div class="col-lg-3 col-md-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="fa fa-cogs fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge">{{ \App\Service::count() }}</div>
                            <div>الخدمات</div>
                        </div>
                    </div>
                </div>
                <a href="{{ url('admin/services') }}">
                    <div class="panel-footer">
                        <span class="pull-left">عرض التفاصيل</span>
                        <span class="pull-right"><i class="fa fa-arrow-circle-left"></i></span>
                        <div class="clearfix"></div>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="panel panel-green">
                <div class="panel-heading" style="background-color: #5cb85c; color: white;">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="fa fa-briefcase fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge">{{ \App\Portfolio::count() }}</div>
                            <div>الأعمال</div>
                        </div>
                    </div>
                </div>
                <a href="{{ url('admin/portfolio') }}">
                    <div class="panel-footer">
                        <span class="pull-left">عرض التفاصيل</span>
                        <span class="pull-right"><i class="fa fa-arrow-circle-left"></i></span>
                        <div class="clearfix"></div>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="panel panel-warning">
                <div class="panel-heading" style="background-color: #f0ad4e; color: white;">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="fa fa-envelope fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge">{{ \App\ContactUs::count() }}</div>
                            <div>رسائل التواصل</div>
                        </div>
                    </div>
                </div>
                <a href="{{ url('admin/get_contact_us') }}">
                    <div class="panel-footer">
                        <span class="pull-left">عرض التفاصيل</span>
                        <span class="pull-right"><i class="fa fa-arrow-circle-left"></i></span>
                        <div class="clearfix"></div>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="panel panel-danger">
                <div class="panel-heading" style="background-color: #d9534f; color: white;">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="fa fa-newspaper-o fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge">{{ \App\Blog::count() }}</div>
                            <div>المقالات</div>
                        </div>
                    </div>
                </div>
                <a href="{{ url('admin/blogs') }}">
                    <div class="panel-footer">
                        <span class="pull-left">عرض التفاصيل</span>
                        <span class="pull-right"><i class="fa fa-arrow-circle-left"></i></span>
                        <div class="clearfix"></div>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <!-- Recent Contacts -->
    <div class="row">
        <div class="col-lg-8">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <i class="fa fa-envelope"></i> آخر رسائل التواصل
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>الاسم</th>
                                    <th>البريد</th>
                                    <th>العنوان</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach(\App\ContactUs::latest()->take(5)->get() as $contact)
                                <tr>
                                    <td>{{ $contact->name }}</td>
                                    <td>{{ $contact->email }}</td>
                                    <td>{{ Str::limit($contact->title, 30) }}</td>
                                    <td>{{ $contact->created_at->diffForHumans() }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <a href="{{ url('admin/get_contact_us') }}" class="btn btn-default btn-block">عرض جميع الرسائل</a>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <i class="fa fa-clock-o"></i> النشاط الأخير
                </div>
                <div class="panel-body">
                    @if(class_exists('\App\ActivityLog'))
                        @foreach(\App\ActivityLog::latest()->take(5)->get() as $log)
                        <div class="list-group-item">
                            <span class="badge">{{ $log->created_at->diffForHumans() }}</span>
                            {{ $log->action }}
                        </div>
                        @endforeach
                    @else
                        <p class="text-muted">لا يوجد نشاط مسجل</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <style>
    .huge {
        font-size: 40px;
    }
    .panel-heading a, .panel-footer a {
        color: inherit;
    }
    .panel-green > .panel-heading {
        border-color: #5cb85c;
    }
    .panel-footer {
        padding: 10px 15px;
        background-color: #f5f5f5;
        border-top: 1px solid #ddd;
    }
    </style>
@endsection
