@extends('admin.layout')
@section('styleCode')


@stop
@section('content')

<!-- BEGIN PAGE HEADER-->
<h3 class="page-title">
  إعدادات تواصل معنا <small>تعديل بيانات</small>
</h3>
<div class="page-bar">
  <ul class="page-breadcrumb">
    <li>
      <i class="fa fa-home"></i>
      <a href="{{URL::to('/admin/#')}}">الرئيسيه</a>
      <i class="fa fa-angle-right"></i>
    </li>
    <li>
      <a href="{{URL::to('/admin/#')}}">إعدادات تواصل معنا</a>
      <i class="fa fa-angle-right"></i>
    </li>
    <li>
      <a href="#">تعديل بيانات</a>
    </li>
  </ul>
</div>
<!-- END PAGE HEADER-->
<!-- BEGIN SAMPLE FORM PORTLET-->
<div class="portlet box purple ">
  <div class="portlet-title">
    <div class="caption">
      <i class="fa fa-gift"></i>تعديل بيانات
    </div>
    <div class="tools">
      <a href="" class="collapse">
      </a>

      <a href="" class="reload">
      </a>
      <a href="" class="remove">
      </a>
    </div>
  </div>


  <div class="portlet-body form">
    <form action="{{ url('admin/contact_us_settings') }}" method="POST" class="form-horizontal" role="form" enctype="multipart/form-data">@csrf
    @if (count($errors) > 0)
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
      </ul>
    </div>
    @endif
    @if(Session::has('success'))
    <div class="alert alert-success">{{Session::get('success')}}</div>
    @endif
    <div class="form-body row">

      {{--site name--}}
      <div class="col-md-9">
        <div class="form-group ">
          <label class="col-md-2 control-label">اسم الموقع</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="name" value="{{@$info->name}}">
          </div>
        </div>
        {{--site name--}}
        {{--description name--}}
          <div class="form-group ">
            <label class="col-md-2 control-label">نبذه عن الموقع</label>
            <div class="col-md-9" >
              <textarea name="description" class="form-control">{{@$info->description}}</textarea>
            </div>
          </div>
          {{--description name--}}
        {{--keywords--}}
        <div class="form-group">
          <label class="col-md-2 control-label">الكلمات الدلاليه</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="meta_tags" value="{{@$info->meta_tags}}"  >
          </div>
        </div>
        {{--keywords--}}
        {{--email--}}
        <div class="form-group">
          <label class="col-md-2 control-label">البريد الإلكتروني</label>
          <div class="col-md-9" >
            <input type="email" class="form-control" name="email" value="{{@$info->email}}">
          </div>
        </div>
        {{--email--}}
        {{--phone--}}
        <div class="form-group">
          <label class="col-md-2 control-label">رقم الجوال</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="phone" value="{{@$info->phone}}"  >
          </div>
        </div>
        {{--phone--}}
        {{--fb--}}
        <div class="form-group">
          <label class="col-md-2 control-label">رابط فيس بوك</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="fburl" value="{{@$info->fburl}}"  >
          </div>
        </div>
        {{--fb--}}
        {{--twitter_url--}}
        <div class="form-group">
          <label class="col-md-2 control-label">رابط تويتر</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="twitter_url" value="{{@$info->twitter_url}}"  >
          </div>
        </div>
        {{--twitter_url--}}
        {{--google_url--}}
        <div class="form-group">
          <label class="col-md-2 control-label">رابط جوجل بلس</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="google_url" value="{{@$info->google_url}}"  >
          </div>
        </div>
        {{--google_url--}}
        {{--instgram_url--}}
        <div class="form-group">
          <label class="col-md-2 control-label">رابط انستجرام</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="instgram_url" value="{{@$info->instgram_url}}"  >
          </div>
        </div>
        {{--instgram_url--}}
        {{--youtube_url--}}
        <div class="form-group">
          <label class="col-md-2 control-label">رابط يوتيوب</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="youtube_url" value="{{@$info->youtube_url}}"  >
          </div>
        </div>
        {{--youtube_url--}}
        {{--linkedin_url--}}
        <div class="form-group">
          <label class="col-md-2 control-label">رابط لينكد إن</label>
          <div class="col-md-9" >
            <input type="text" class="form-control" name="linkedin_url" value="{{@$info->linkedin_url}}"  >
          </div>
        </div>
        {{--linkedin_url--}}
        {{--linkedin_url--}}
        <div class="form-group">
          <label class="col-md-2 control-label">تضمين الخريطه</label>
          <div class="col-md-9" >
            {{--<input type="text" class="form-control" name="map" value="{{@$info->map}}"  >--}}
            <textarea name="map" class="form-control">{{@$info->map}}</textarea>
          </div>
        </div>
        {{--linkedin_url--}}
        {{--image--}}
        <div class="form-group">
          <label class="col-md-3 control-label">الصوره</label>
          <div class="col-md-9">
            <!-- The fileupload-buttonbar contains buttons to add/delete files and start/cancel the upload -->
            <div class="row fileupload-buttonbar">
              <div class="col-lg-7">
                <!-- The fileinput-button span is used to style the file input field as button -->
                <span class="btn green fileinput-button">
                    <i class="fa fa-plus"></i>
                    <span>
                    تصفح جهازك... </span>
                    <input type="file" name="logo"  >
                    </span>
              </div>
              <!-- The global progress information -->
            </div>
            <!-- The table listing the files available for upload/download -->
          </div>
        </div>
        {{--image--}}

        {{--location--}}
        <div class="form-group">
          <label class="col-md-2 control-label">اختيار العنوان</label>
          <div class="col-md-9">
            <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAK34ZyoH4758BkVP05-GxKP0dSmBi4yTo&libraries=places"></script>
            <script type="text/javascript">
                var x = document.getElementById("address1");
                function getLocation() {
                    if (navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(showPosition);
                    } else {
                        x.innerHTML = "Geolocation is not supported by this browser.";
                    }
                }
                function showPosition(position) {
                    document.getElementById('cityLat').value = position.coords.latitude;
                    document.getElementById('cityLng').value =  position.coords.longitude;
                    document.getElementById('cityLat1').value = position.coords.latitude;
                    document.getElementById('cityLng1').value =  position.coords.longitude;
                    document.getElementById('address1').value ='';
                }
                //start live search locaton and get lat & long
                function findAddress() {
                    var input = document.getElementById('address1');
                    var autocomplete = new google.maps.places.Autocomplete(input);
                    google.maps.event.addListener(autocomplete, 'place_changed', function () {
                        var place = autocomplete.getPlace();
                        document.getElementById('cityLat').value = place.geometry.location.lat();
                        document.getElementById('cityLng').value = place.geometry.location.lng();
                        document.getElementById('cityLat1').value = place.geometry.location.lat();
                        document.getElementById('cityLng1').value = place.geometry.location.lng();
                    });
                }
                //end live search
            </script>
            <div class="col-md-12" style="margin: 10px">
              <input type="text" name="address" id="address1" class="form-control"  onkeyup="findAddress()"  value="{{@$info->address}}" title="اختياري" />
            </div>
            <div class="col-md-12" style="margin: 10px">
              <div class="col-md-3">
                <input type="text" name="lat" id="cityLat1" placeholder="Lattitude" class="form-control" required="required" value="{{@$info->lat}}" disabled />
                <input type="hidden" name="lat" id="cityLat" placeholder="Lattitude" class="form-control" required="required" value="{{@$info->lat}}" />
              </div>
              <div class="col-md-3">
                <input type="text" name="long" id="cityLng1" placeholder="Longitude" class="form-control" required="required" value="{{@$info->long}}" disabled  />
                <input type="hidden" name="long" id="cityLng" placeholder="Longitude" class="form-control" required="required" value="{{@$info->long}}" />
              </div>
              <div class="col-md-3">
                <button type="button" class="btn btn-primary fa fa-map-marker" style="" onclick="getLocation()"> تحديد الموقع الحالي</button>
              </div>
            </div>
          </div>
        </div>
        {{--location--}}

      </div>
      <div class="col-md-2">
        <img src="{{URL::to('').@$info->logo}}" class="img-responsive img-rounded img-circle">
      </div>

      </div>




    <div class="form-actions right1">
      <button type="submit" class="btn green">حفظ</button>
    </div>
  </form>
</div>
</div>

<!-- END SAMPLE FORM PORTLET-->
@stop
@section('jsCode')


@stop