@extends('admin.layout')
@section('styleCode')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css"/>
@stop
@section('content')
 <!-- BEGIN PAGE HEADER-->
<h3 class="page-title">
    طلبات التواصل <small>قائمة طلبات التاوصل</small>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="{{URL::to('/admin/contact_us')}}">الرئيسيه</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="{{URL::to('/admin/contact_us')}}">طلبات التواصل</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="#">قائمة طلبات التواصل</a>
        </li>
    </ul>
</div>
<!-- END PAGE HEADER-->
  @if(Session::has('success'))
  <div class="alert alert-success">{{Session::get('success')}}</div>
  @endif
    <!-- END EXAMPLE TABLE PORTLET-->
    <table id="" class="table table-striped table-bordered table-hover" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>#</th>
                <th>الاسم بالعربيه</th>
                <th>الاسم بالانجليزيه</th>
                <th>الخدمه</th>
                <th>التاريخ</th>
                <th>رد</th>
               <th>حذف</th>
            </tr>
        </thead>
        <tfoot>
         <tr>
             <th>#</th>
             <th>الاسم بالعربيه</th>
             <th>البريد الإلكتروني</th>
             <th>الخدمه</th>
             <th>رد</th>
             <th>حذف</th>
            </tr>
        </tfoot>
        <tbody>
        @foreach($infos as $info)
        <tr>
            <td>
            {{@$info->id}} 
            @if($info->read == 0)
            <span style="text-transform: capitalize;border: 1px solid #ccc; border-radius: 18px;font-weight: bolder" class="label label-primary">لم يتم القراءه</span>
            @elseif($info->reply == 1)
              <span style="text-transform: capitalize;border: 1px solid #ccc; border-radius: 5px;font-weight: bolder" class="label label-info">تم  الرد</span>
            @endif
            </td>
            <td>{{@$info->name}}</td>
            <td>{{@$info->email}}</td>
            <td>
                @if($info->service_id == NULL)
                 لم يتم اختيار خدمه
                @else
                {{@$info->service->name}}
                @endif
            </td>
                        <td>{{@$info->created_at}}</td>

            <td>
             <center><a href="{{URL::to('/')}}/admin/contact_us/{{@$info->id}}/reply"><li class="fa fa-paper-plane btn btn-primary"></li></a></center>
            </td>
           
            <td>
                <center><a href="{{URL::to('/')}}/admin/contact_us/{{@$info->id}}/delete"><li class="fa fa-trash-o btn btn-danger"></li></a></center>
            </td>
        </tr>
        @endforeach
        <tr> {{@$infos->links()}}</tr>
        </tbody>
    </table>
    <!-- END EXAMPLE TABLE PORTLET-->
@stop
@section('jsCode')
<script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function() {
    $('#example').DataTable();
} );
</script>
@stop