@extends('admin.layout')
@section('content')
 <!-- BEGIN PAGE HEADER-->
  <h3 class="page-title">
المدونه <small>تعديل بيانات</small>
  </h3>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <i class="fa fa-home"></i>
        <a href="{{URL::to('/admin/home')}}">الرئيسيه</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="{{URL::to('/admin')}}/blogs">المقالات</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="#">تعديل بيانات</a>
      </li>
    </ul>
  </div>
  <!-- END PAGE HEADER-->
  <!-- BEGIN SAMPLE FORM PORTLET-->
  <div class="portlet box purple ">
    <div class="portlet-title">
      <div class="caption">
        <i class="fa fa-gift"></i>تعديل بيانات
      </div>
      <div class="tools">
        <a href="" class="collapse">
        </a>

        <a href="" class="reload">
        </a>
        <a href="" class="remove">
        </a>
      </div>
    </div>
    <div class="portlet-body form col-md-12">
    <div class="form col-md-9">
    <form action="{{ url('admin/blogs/'.$info->id) }}" method="POST" class="form-horizontal" role="form" enctype="multipart/form-data">
      @csrf
      @method('PUT')
      @if (count($errors) > 0)
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
      @endif
      @if(Session::has('success'))
      <div class="alert alert-success">{{Session::get('success')}}</div>
      @endif
        <div class="form-body">
            <div class="form-group">
          <label class="col-md-2 control-label">عنوان المقال</label>
          <div class="col-md-9">
            <input type="text" name="title"
                   class="form-control input-lg"
                   placeholder="عنوان المقال.."
                   value="{{@$info->title }}">
          </div>
        </div>

        <!-- SEO Settings -->
        <div class="form-group">
            <label class="col-md-2 control-label">عنوان SEO</label>
            <div class="col-md-9">
              <input type="text" name="meta_title" class="form-control" maxlength="70" placeholder="عنوان الصفحة لمحركات البحث (70 حرف كحد أقصى)" value="{{ @$info->meta_title }}">
              <small class="help-block">اتركه فارغاً لاستخدام عنوان المقال</small>
            </div>
        </div>

        <div class="form-group">
            <label class="col-md-2 control-label">وصف SEO</label>
            <div class="col-md-9">
              <textarea name="meta_description" class="form-control" maxlength="160" rows="2" placeholder="وصف الصفحة لمحركات البحث (160 حرف كحد أقصى)">{{ @$info->meta_description }}</textarea>
            </div>
        </div>
        <!-- End SEO Settings -->

        <div class="form-group">
            <label class="col-md-2 control-label">الكلمات الدلاليه</label>
            <div class="col-md-9">
                <input type="text"
                       name="keywords"
                       class="form-control input-lg"
                       placeholder="الكلمات الدلاليه.."
                       value="{{ @$info->keywords }}">
            </div>
        </div>

        <div class="form-group">
            <label class="col-md-2 control-label">المحتوي</label>
            <div class="col-md-9">
                <textarea
                        class="form-control"
                           id="editor1"
                           name="content">
                    {{ @$info->content }}
                </textarea>
            </div>
        </div>


        <div class="form-group">
            <label class="col-md-2 control-label">الصوره</label>
            <div class="col-md-9">
                <div class="row fileupload-buttonbar">
                    <div class="col-lg-7">
                        <span class="btn green fileinput-button">
                        <i class="fa fa-plus"></i>
                        <span>
                        تصفح جهازك... </span>
                        <input type="file" name="image"  >
                        </span>
                    </div>
                </div>
            </div>
          </div>
          
          <div class="form-actions right1">
            <button type="submit" class="btn green">تحديث</button>
          </div>
        </form>
    </div>
    </div>
    <div class="form col-md-3">
    <img src="{{ URL::to('/') }}{{ @$info->image }}" class="img-responsive img-rounded" >
    </div>
     
  </div>
  <!-- END SAMPLE FORM PORTLET-->
@stop