@extends('admin.layout')
@section('styleCode')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css"/>
@stop
@section('content')
  <!-- BEGIN PAGE HEADER-->
  <h3 class="page-title">
المسؤلين <small>قائمة المسؤلين</small>
  </h3>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <i class="fa fa-home"></i>
        <a href="{{URL::to('/admin/admins')}}">الرئيسيه</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="{{URL::to('/admin/categories')}}">المسؤلين</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="#">قائمة المسؤلين</a>
      </li>
    </ul>
  </div>
  <!-- END PAGE HEADER-->
  @if(Session::has('success'))
  <div class="alert alert-success">{{Session::get('success')}}</div>
  @endif
    <!-- END EXAMPLE TABLE PORTLET-->
    <table id="example" class="table table-striped table-bordered table-hover" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>#</th>
                <th>الاسم</th>
                <th>البريد الإلكتروني</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tfoot>
         <tr>
                <th>#</th>
                <th>الاسم</th>
                <th>البريد الإلكتروني</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
        </tfoot>
        <tbody>
        @foreach($admins as $admin)
            <tr>
                <td>{{@$admin->id}}</td>
                <td>{{@$admin->name}}</td>
                <td>{{@$admin->email}}</td>
                <td>
                   <center><a href="{{URL::to('/')}}/admin/admins/{{@$admin->id}}/edit"><li class="fa fa-pencil btn btn-warning"></li></a></center>
                </td>
                <td>
                    <center><a href="{{URL::to('/')}}/admin/admin/{{@$admin->id}}/delete"><li class="fa fa-trash-o btn btn-danger"></li></a></center>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <!-- END EXAMPLE TABLE PORTLET-->
@stop
@section('jsCode')
<script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function() {
    $('#example').DataTable();
} );
</script>
@stop
