@extends('admin.layout')
  @section('content')
  <!-- BEGIN PAGE HEADER-->
  <h3 class="page-title">
المسؤلين <small>إضافه مسؤل جديد</small>
  </h3>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <i class="fa fa-home"></i>
        <a href="{{URL::to('/admin/admins')}}">الرئيسيه</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="{{URL::to('/admin/admins')}}">المسؤلين</a>
        <i class="fa fa-angle-right"></i>
      </li>
      <li>
        <a href="#">اضافه مسؤل جديد</a>
      </li>
    </ul>
  </div>
  <!-- END PAGE HEADER-->
  <!-- BEGIN SAMPLE FORM PORTLET-->
  <div class="portlet box purple ">
    <div class="portlet-title">
      <div class="caption">
        <i class="fa fa-gift"></i> إضافه مسؤول جديد
      </div>
      <div class="tools">
        <a href="" class="collapse">
        </a>

        <a href="" class="reload">
        </a>
        <a href="" class="remove">
        </a>
      </div>
    </div>
    <div class="portlet-body form">
      <form action="{{ url('admin/admins') }}" method="POST" class="form-horizontal" role="form" enctype="multipart/form-data">@csrf
      @if (count($errors) > 0)
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
      @endif
      @if(Session::has('success'))
      <div class="alert alert-success">{{Session::get('success')}}</div>
      @endif
        <div class="form-body">
          <div class="form-group">
            <label class="col-md-3 control-label">الإسم </label>
            <div class="col-md-9">
              <input type="text" name="name" class="form-control input-lg" required placeholder="الإسم" value="{{Request::old('name')}}">
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 control-label">البريد االكتروني </label>
            <div class="col-md-9">
              <input type="email" name="email" class="form-control input-lg" required placeholder="البريد الالكتروني" value="{{Request::old('email')}}">
            </div>
          </div>
         
         <div class="form-group">
            <label class="col-md-3 control-label">الصوره</label>
            <div class="col-md-9">
              <!-- The fileupload-buttonbar contains buttons to add/delete files and start/cancel the upload -->
  						<div class="row fileupload-buttonbar">
  							<div class="col-lg-7">
  								<!-- The fileinput-button span is used to style the file input field as button -->
  								<span class="btn green fileinput-button">
  								<i class="fa fa-plus"></i>
  								<span>
  								تصفح جهازك... </span>
  								<input type="file" name="image"  >
  								</span>
  							</div>
  							<!-- The global progress information -->
  						</div>
  						<!-- The table listing the files available for upload/download -->
            </div>
          </div>

          <div class="form-group">
            <label class="col-md-3 control-label">كلمة المرور</label>
            <div class="col-md-9">
              <input type="password" name="password" class="form-control input-lg" required placeholder="الرقم السري" value="{{Request::old('password')}}">
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 control-label">تأكيد كلمة المرور</label>
            <div class="col-md-9">
              <input type="password" name="password_confirmation" class="form-control input-lg" required placeholder="تأكيد كلمة المرور" value="{{Request::old('password_confirmation')}}">
            </div>
          </div>
        </div>
        <div class="form-actions right1">
          <button type="submit" class="btn green">اضافه</button>
        </div>
        </form>
    </div>
  </div>
  <!-- END SAMPLE FORM PORTLET-->
  @stop
