# Design System Checklist - تطبيق التصميم الموحد

قائمة التحقق لتطبيق Design System على جميع صفحات الموقع.

---

## ✅ الصفحات المكتملة:

### 1. الصفحة الرئيسية (index.blade.php)
- [x] Hero Section مع gradient
- [x] قسم الخدمات - Carousel 6 كروت
- [x] قسم الأعمال - Carousel مع فلتر
- [x] قسم الاستضافة - Grid 3 أعمدة
- [x] تصميم الكروت الموحد

### 2. صفحة من نحن (about_us.blade.php)
- [x] Hero Section مع breadcrumb بسيط
- [x] قسم الميزات - 4 كروت مع hover effect
- [x] قسم التبويبات (من نحن/رسالتنا/أهدافنا/رؤيتنا)
- [x] قسم الإحصائيات مع عداد متحرك
- [x] قسم "نحن نساعدك" مع CTA
- [x] قسم CTA النهائي

---

## 📋 Checklist للصفحات المتبقية:

### لكل صفحة، تأكد من:

#### Hero Section:
- [ ] استخدام class: `ds-hero ds-page-hero`
- [ ] العنوان: `ds-hero-title ds-text-center`
- [ ] Breadcrumb بسيط: `<p class="ds-breadcrumb">الرئيسية / اسم الصفحة</p>`

#### الأقسام:
- [ ] استخدام class: `ds-section` أو `ds-section ds-section-alt`
- [ ] العناوين: `ds-section-title ds-text-center`
- [ ] الوصف: `ds-section-desc ds-text-center`

#### الكروت:
- [ ] استخدام class: `ds-card`
- [ ] للخدمات: `ds-service-card`
- [ ] للأعمال: `ds-portfolio-card`
- [ ] للمدونة: `ds-blog-card`
- [ ] للأسعار: `ds-pricing-card`

#### الأزرار:
- [ ] استخدام class: `ds-btn ds-btn-primary`
- [ ] للأزرار الكبيرة: `ds-btn ds-btn-primary ds-btn-lg`
- [ ] للأزرار الثانوية: `ds-btn ds-btn-outline`

#### Grid:
- [ ] 3 أعمدة: `ds-grid ds-grid-3`
- [ ] 4 أعمدة: `ds-features-grid`
- [ ] للأسعار: `ds-pricing-grid`

---

## 📄 الصفحات المتبقية للتطبيق:

### 3. صفحة الخدمة (service.blade.php)
- [ ] Hero Section
- [ ] محتوى الخدمة
- [ ] Sidebar

### 4. صفحة الأعمال (portfolio.blade.php)
- [ ] Hero Section
- [ ] فلتر الأقسام
- [ ] Grid الأعمال

### 5. صفحة المشروع (singel_portfolio.blade.php)
- [ ] Hero Section
- [ ] معرض الصور
- [ ] معلومات المشروع

### 6. صفحة المدونة (blogs.blade.php)
- [ ] Hero Section
- [ ] Grid المقالات

### 7. صفحة المقال (show_blog.blade.php)
- [ ] Hero Section
- [ ] محتوى المقال
- [ ] Sidebar

### 8. صفحة تواصل معنا (contactus.blade.php)
- [x] Hero Section (تم)
- [ ] نموذج الاتصال
- [ ] معلومات التواصل

### 9. صفحة الأسئلة الشائعة (faq.blade.php)
- [x] Hero Section (تم)
- [ ] تصميم الأسئلة

### 10. صفحة 404 (404.blade.php)
- [ ] تصميم موحد

---

## 🎨 CSS Classes Reference:

```css
/* Hero */
.ds-hero, .ds-page-hero, .ds-hero-title, .ds-breadcrumb

/* Sections */
.ds-section, .ds-section-alt, .ds-section-title, .ds-section-desc

/* Cards */
.ds-card, .ds-service-card, .ds-portfolio-card, .ds-blog-card, .ds-pricing-card

/* Features */
.ds-features-grid, .ds-feature-card, .ds-feature-icon

/* Tabs */
.ds-tabs-section, .ds-tabs-nav, .ds-tab-btn, .ds-tab-content, .ds-tab-panel

/* Stats */
.ds-stats-section, .ds-stats-grid, .ds-stat-item, .ds-stat-number, .ds-stat-label

/* Buttons */
.ds-btn, .ds-btn-primary, .ds-btn-outline, .ds-btn-lg

/* Grid */
.ds-grid, .ds-grid-3, .ds-pricing-grid

/* CTA */
.ds-cta-section

/* Utilities */
.ds-text-center, .ds-text-white, .ds-mb-6
```

---

## 📝 ملاحظات:
- تأكد من مسح الكاش بعد كل تعديل: `php artisan view:clear`
- اختبر على Ctrl + F5 في المتصفح
- تأكد من RTL في جميع الأقسام
