<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Add SEO fields to services table
        Schema::table('services', function (Blueprint $table) {
            $table->string('meta_title', 70)->nullable()->after('name');
            $table->string('meta_description', 160)->nullable()->after('meta_title');
        });

        // Add SEO fields to blogs table
        Schema::table('blogs', function (Blueprint $table) {
            $table->string('meta_title', 70)->nullable()->after('title');
            $table->string('meta_description', 160)->nullable()->after('meta_title');
        });

        // Add SEO fields to portfolio table
        Schema::table('portfolio', function (Blueprint $table) {
            $table->string('meta_title', 70)->nullable()->after('name');
            $table->string('meta_description', 160)->nullable()->after('meta_title');
        });
    }

    public function down(): void
    {
        Schema::table('services', function (Blueprint $table) {
            $table->dropColumn(['meta_title', 'meta_description']);
        });

        Schema::table('blogs', function (Blueprint $table) {
            $table->dropColumn(['meta_title', 'meta_description']);
        });

        Schema::table('portfolio', function (Blueprint $table) {
            $table->dropColumn(['meta_title', 'meta_description']);
        });
    }
};
