<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hosts',function (Blueprint $table)
        {
            $table->increments('id');   
            $table->string('name')->default('');
            $table->string('price')->default('');
            $table->string('space')->default('');
            $table->string('email')->default('');
            $table->string('bandwidth')->default('');
            $table->string('subdomains')->default('');
            $table->string('domains')->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('hosts');

    }
}
