<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContactUsSettingsTable extends Migration
{
     /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contactus_settings', function (Blueprint $table)
        {
            $table->increments('id');
            $table->string('name')->default('');
            $table->string('email')->default('');
            $table->string('phone')->default('');
            $table->string('logo')->default('');
            $table->string('meta_tags')->default('');
            $table->string('fburl')->default('');
            $table->string('twitter_url')->default('');
            $table->string('google_url')->default('');
            $table->string('instgram_url')->default('');
            $table->string('youtube_url')->default('');
            $table->string('linkedin_url')->default('');
            $table->string('lat')->default('');
            $table->string('long')->default('');
            $table->longText('map');
            $table->string('address')->default('');
            $table->string('description')->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('contactus_settings');
    }
}
