<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContactUsTable extends Migration
{
   /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact_us', function (Blueprint $table)
        {
            $table->increments('id');   
            $table->string('title')->default('');
            $table->string('name')->default('');
            $table->string('phone')->default('');
            $table->string('email')->default('');
            $table->enum('read',['0','1'])->default('0');
            $table->enum('reply',['0','1'])->default('0');
            $table->integer('service_id')->nullable()->unsigned();
            $table->foreign('service_id')->references('id')->on('services')->onDelete('cascade');
            $table->longText('message');   
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('contact_us');
    }
}
