<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class Testmnial extends Model
{
    protected $table = "testmonials";
    protected $fillable = [
				    		'name',
				    		'position',
							'image',
							'comment',
				    	];
				    	
	public function setImageAttribute($image): void
	{
		if ($image instanceof UploadedFile && $image->isValid()) {
			$time = time();
			$ext = $image->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
			$image->move(public_path('uploads/images/testmonials'), $fullname);
			$path = '/uploads/images/testmonials';
			$this->attributes['image'] = $path . '/' . $fullname;
		} elseif (is_string($image) && !empty($image)) {
			$this->attributes['image'] = $image;
		}
	}
}
