<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
class  SubService extends Model
{
    protected  $table = "sub_services";
    protected $guarded = ['id'];
    // protected  $appends = ['services'];
	protected  $hidden = ['created_at','updated_at'];
    
	protected $fillable = [
					'name','time','service_id','salone_id','price'
					];

 	 public function user()
    {
        return $this->hasOne('App\User','id','salone_id');
    }


    public function service()
    {
        return $this->hasOne('App\Service','id','service_id');
    }


  public function salons()
  {
    return $this->hasMany('App\User','id','salone_id');
  }


  public function main_services()
  {
    return $this->hasMany('App\Service','id','service_id');
  }

}
