<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class Slider extends Model
{
    protected $table = 'slider';
	protected  $hidden = ['created_at','updated_at'];
    protected $fillable = [
        'title_ar','title_en','content_ar','content_en','image'
    ];
    
    public function setImageAttribute($image): void
	{
		if ($image instanceof UploadedFile && $image->isValid()) {
			$time = time();
			$ext = $image->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
			$image->move(public_path('uploads/images/sliders'), $fullname);
			$path = '/uploads/images/sliders';
			$this->attributes['image'] = $path . '/' . $fullname;
		} elseif (is_string($image) && !empty($image)) {
			$this->attributes['image'] = $image;
		}
	}
}
