<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class Service extends Model
{
	protected  $table = "services";
	protected  $hidden = ['created_at','updated_at'];
	
	protected $fillable = ['name','meta_title','meta_description','icon','content','keywords','details','menu','default'];

	public function setIconAttribute($icon): void
	{
		if ($icon instanceof UploadedFile && $icon->isValid()) {
			$time = time();
			$ext = $icon->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
			$icon->move(public_path('uploads/services'), $fullname);
			$path = '/uploads/services';
			$this->attributes['icon'] = $path . '/' . $fullname;
		} elseif (is_string($icon) && !empty($icon)) {
			$this->attributes['icon'] = $icon;
		}
	}

		
	public function portfolio()
	{
		return $this->hasMany('App\Portfolio','service_id','id');
	}

   

}
