<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Blade;
use App\AboutUs;
use App\Service;
use App\ContactUsSetting;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        try {
            DB::connection()->getPdo();
            
            if (Schema::hasTable('about_us')) {
                View::share('info', AboutUs::first());
            } else {
                View::share('info', null);
            }
            
            if (Schema::hasTable('contactus_settings')) {
                View::share('setting', ContactUsSetting::first());
            } else {
                View::share('setting', null);
            }
            
            if (Schema::hasTable('services')) {
                View::share('services', Service::all());
                View::share('menuservices', Service::where('menu', '1')->get());
            } else {
                View::share('services', collect());
                View::share('menuservices', collect());
            }
        } catch (\Exception $e) {
            View::share('info', null);
            View::share('setting', null);
            View::share('services', collect());
            View::share('menuservices', collect());
        }
    }
}
