<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Portfolio extends Model
{
    protected $table = "portfolio";
    protected $fillable = [
                    'meta_title',
                    'meta_description',
                    'keywords',
                    'meta_type',
                    'meta_image',
                    'name',
                    'content',
                    'service_id',
                    'android',
                    'ios',
                    'website'
    ];

    public function service()
    {
        return $this->belongsTo('App\Service','service_id','id');
    }

    public function images()
    {
        return $this->hasMany('App\ProjectImage','portfolio_id','id');
    }

    public function image()
{
    return $this->images()->first();
}
}
