<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class Offer extends Model
{
	protected  $table = "offers";
	protected  $hidden = ['created_at','updated_at'];
	
	protected $fillable = [
					'name','details','icon',
					];

	public function setIconAttribute($icon): void
	{
		if ($icon instanceof UploadedFile && $icon->isValid()) {
			$time = time();
			$ext = $icon->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
			$icon->move(public_path('uploads/offers'), $fullname);
			$path = '/uploads/offers';
			$this->attributes['icon'] = $path . '/' . $fullname;
		} elseif (is_string($icon) && !empty($icon)) {
			$this->attributes['icon'] = $icon;
		}
	}
}
