<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemOrder extends Model
{
    use SoftDeletes;

	protected $table = "items_order";
	

	protected $fillable = [
		'main_service_id',
		'order_id',
		'sub_service_id',
		'salone_id',
		'user_id',
		'date',
		'time',
		'status',
		'payment_type',
		'done_paid',
		'price'
	];

	protected $hidden = [
		'created_at',
		'updated_at',
		'deleted_at'
	 ];
 	
 	/**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];


	public function MainItem()
    {
    return $this->hasOne('App\Service','id','main_service_id');
    }
   
    public function items()
    {
    return $this->hasMany('App\SubService','id','order_id');
    }

    public function subservice()
    {
    return $this->hasOne('App\SubService','id','sub_service_id');
    }

    public function MainOrderInfo()
    {
    return $this->hasOne('App\Order','id','order_id');
    }

    public function item()
    {
    return $this->hasOne('App\SubService','id','sub_service_id');
    }

    public function salone()
    {
    return $this->hasOne('App\User','id','salone_id');
    }


    public function user()
    {
    return $this->hasOne('App\User','id','user_id');
	}

	public function salon()
    {
    return $this->hasOne('App\User','id','salone_id');
	}


    public function OrderMainInfo()
    {
    return $this->hasOne('App\Order','id','order_id');
    // return $this->hasMany('App\Order','id','order_id');
    }

  
}
