<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
               return array();
           }
           case 'POST':
           {
               return array(
                'name'=>'required|min:2|max:100',
                'icon'=>'required|image|mimes:jpeg,jpg,png,gif,webp|max:2048|dimensions:min_width=50,min_height=50,max_width=2000,max_height=2000',
                'meta_title'=>'nullable|max:70',
                'meta_description'=>'nullable|max:160',
                );
           }
           case 'PUT':
           {
               return array(
                'name'=>'required|min:2|max:100',
                'icon'=>'nullable|image|mimes:jpeg,jpg,png,gif,webp|max:2048|dimensions:min_width=50,min_height=50,max_width=2000,max_height=2000',
                'meta_title'=>'nullable|max:70',
                'meta_description'=>'nullable|max:160',
                );
           }
           case 'PATCH':
               return [];
       }
    }

    public function messages()
    {
        return [
            'icon.image' => 'الملف يجب أن يكون صورة',
            'icon.mimes' => 'الصورة يجب أن تكون من نوع: jpeg, jpg, png, gif, webp',
            'icon.max' => 'حجم الصورة يجب أن لا يتجاوز 2 ميجابايت',
            'icon.dimensions' => 'أبعاد الصورة غير مناسبة (50x50 إلى 2000x2000)',
            'meta_title.max' => 'عنوان SEO يجب أن لا يتجاوز 70 حرف',
            'meta_description.max' => 'وصف SEO يجب أن لا يتجاوز 160 حرف',
        ];
    }
}
