<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class PortfolioRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
               return array();
           }
           case 'POST':
           {
               return array(
                    'service_id'=>'required|exists:services,id',
                    'name'=>'required|min:3|max:200',
                    'content'=>'required|min:10',
                    'images.*'=>'nullable|image|mimes:jpeg,jpg,png,gif,webp|max:2048',
                    'meta_title'=>'nullable|max:70',
                    'meta_description'=>'nullable|max:160',
                );
           }
           case 'PUT':
           {
               return array(
                    'service_id'=>'required|exists:services,id',
                    'name'=>'required|min:3|max:200',
                    'content'=>'required|min:10',
                    'images.*'=>'nullable|image|mimes:jpeg,jpg,png,gif,webp|max:2048',
                    'meta_title'=>'nullable|max:70',
                    'meta_description'=>'nullable|max:160',
                );
           }
           case 'PATCH':
               return [];
       }
    }

    public function messages()
    {
        return [
            'service_id.required' => 'يرجى اختيار الخدمة',
            'service_id.exists' => 'الخدمة المختارة غير موجودة',
            'name.required' => 'اسم العمل مطلوب',
            'content.required' => 'وصف العمل مطلوب',
            'images.*.image' => 'الملف يجب أن يكون صورة',
            'images.*.mimes' => 'الصورة يجب أن تكون من نوع: jpeg, jpg, png, gif, webp',
            'images.*.max' => 'حجم الصورة يجب أن لا يتجاوز 2 ميجابايت',
        ];
    }
}
