<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class BlogRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
               return array();
           }
           case 'POST':
           {
               return array(
                'title'=>'required|min:3|max:200',
                'content'=>'required|min:10',
                'image'=>'required|image|mimes:jpeg,jpg,png,gif,webp|max:2048',
                'meta_title'=>'nullable|max:70',
                'meta_description'=>'nullable|max:160',
                );
           }
           case 'PUT':
           {
               return array(
                'title'=>'required|min:3|max:200',
                'content'=>'required|min:10',
                'image'=>'nullable|image|mimes:jpeg,jpg,png,gif,webp|max:2048',
                'meta_title'=>'nullable|max:70',
                'meta_description'=>'nullable|max:160',
                );
           }
           case 'PATCH':
               return [];
        }
    }

    public function messages()
    {
        return [
            'title.required' => 'عنوان المقال مطلوب',
            'content.required' => 'محتوى المقال مطلوب',
            'image.image' => 'الملف يجب أن يكون صورة',
            'image.mimes' => 'الصورة يجب أن تكون من نوع: jpeg, jpg, png, gif, webp',
            'image.max' => 'حجم الصورة يجب أن لا يتجاوز 2 ميجابايت',
        ];
    }
}
