<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class AdminsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
             return array();
         }
         case 'POST':
         {
             return [
             'email'=>'required|email|unique:users,email',
             'name'=>'required|min:3',
             'phone'=>'required|numeric',
             'password'=>'required|min:8|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/'
             ];
         }
         case 'PUT':
         {
             return [
             'email'=>'required|email',
             'name'=>'required|min:3',
             'phone'=>'numeric',
             'password'=>'nullable|min:8|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/'
             ];
         }
         case 'PATCH':
             return [];
     }
    }

    public function messages()
    {
        return [
            'password.regex' => 'كلمة المرور يجب أن تحتوي على حرف كبير، حرف صغير، رقم، ورمز خاص (@$!%*?&)',
            'password.min' => 'كلمة المرور يجب أن تكون 8 أحرف على الأقل',
            'email.unique' => 'البريد الإلكتروني مستخدم بالفعل',
            'name.min' => 'الاسم يجب أن يكون 3 أحرف على الأقل',
        ];
    }
}
