<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\ContactUsSetting;
use App\AboutUs;
use App\Service;

class ShareSettingsMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {
            view()->share('setting', ContactUsSetting::first());
            view()->share('info', AboutUs::first());
            view()->share('services', Service::all());
            view()->share('menuservices', Service::where('menu', '1')->get());
        } catch (\Exception $e) {
            view()->share('setting', null);
            view()->share('info', null);
            view()->share('services', collect());
            view()->share('menuservices', collect());
        }
        
        return $next($request);
    }
}
