<?php

namespace App\Http\Controllers;

use App\Service;
use App\Portfolio;
use App\Blog;
use Illuminate\Http\Response;

class SitemapController extends Controller
{
    public function index()
    {
        $services = Service::all();
        $portfolios = Portfolio::all();
        $blogs = Blog::all();

        $content = view('sitemap.index', compact('services', 'portfolios', 'blogs'));
        
        return response($content, 200)
            ->header('Content-Type', 'text/xml');
    }
}
