<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
Use App\Service,App\Portfolio,App\Host,App\Blog;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
   
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $services=Service::with('portfolio')->get();
        $projects = Portfolio::orderBy('created_at','DESC')->get();
        $hosts=Host::get();
        
        return view('site.index',compact('services','projects','hosts'));
      
    }

    public function portfolio()
    {
        $services=Service::with('portfolio')->get();
        $projects = Portfolio::orderBy('created_at','DESC')->get();
        return view('site.portfolio',compact('services','projects'));
    }


    public function about_us()
    {
        return view('site.about_us');
    }


      public function blogs()
    {
        $blogs = Blog::latest()->get();
        return view('site.blogs',compact('blogs'));
    }

    public function faq()
    {
        return view('site.faq');
    }
}
