<?php

namespace App\Http\Controllers;

use App\ContactUs;
use App\ActivityLog;
use App\Http\Requests\Site\ContactUsRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\RateLimiter;

class ContactUsController extends Controller
{
    public function getContact(){
        return view('site.contactus');
    }

    public function send(ContactUsRequest $request){
        // Rate limiting: max 5 submissions per hour per IP
        $key = 'contact-form:' . $request->ip();
        
        if (RateLimiter::tooManyAttempts($key, 5)) {
            $seconds = RateLimiter::availableIn($key);
            Session::flash('error', 'لقد تجاوزت الحد المسموح. يرجى المحاولة بعد ' . ceil($seconds / 60) . ' دقيقة.');
            return redirect()->back();
        }
        
        RateLimiter::hit($key, 3600); // 1 hour decay
        if($request->service_id == ''){
            $service  = NULL;
        }else{
            $service  = $request->service_id;
        }
       $create =  ContactUs::create([
            'title' =>$request->title,
            'name'=>$request->name,
            'email'=>$request->email,
            'service_id'=>$service,
            'phone'=>$request->phone,
            'message'=>$request->message
        ]);

        $email = $request->email;
        $email_prov1 = 'amrmuhamed9@gmail.com';
        $email_prov2 = 'amrmehana47@gmail.com';
        $title = $request->title;
        Mail::send('email.reply', [
            'title' =>$request->title,
            'name'=>$request->name,
            'email'=>$request->email,
            'phone'=>$request->phone,
            'mms'=>$request->message
        ], function ($message) use ($email,$title,$email_prov1,$email_prov2)
        {
            $message->from('no-reply@bedayh4it.com', 'Support.bedayh4it.com');
            $message->to($email)->subject($title);
            $message->to($email_prov1)->subject($title);            
            $message->to($email_prov2)->subject($title);
        });
        Session::flash('success','شكراً لك، تم استلام رسالتك :))');
//        return response()->json( ['status'=>'200','msg'=>'شكرا لك'],200);

        return redirect()->back();
    }
}
